/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    NmSpcItr.h

   Contains:   Definition of XMPAbsValueIterator class

   Written by: Caia Grisar

*/

#ifndef _NMSPCITR_
#define _NMSPCITR_

#ifndef _NAMSPACE_
#include "NamSpace.h"
#endif


//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsValueIterator;

//==============================================================================
// XMPAbsValueIterator
//
// Both key and value are return by the iterator.
//
// This iterator is only meant to be used in the the context of a for loop,
// e.g.:
//
// XMPAbsValueIterator iter;
// for (iter.First(key, value);
//       iter.IsNotComplete();
//       iter.Next(key, value))
// {
//    ...
// }
//
//==============================================================================

class XMPAbsValueIterator
{
  public:

   XMPAbsValueIterator() {}
      // Subclass should have constructor:
      // XMPMacValueIterator(XMPAbsNameSpace* nameSpace);
   XMPVMethod ~XMPAbsValueIterator() {}

      /* If any of the 6 methods below is invoked does not match the
         XMPNSTypeSpec with which the XMPNameSpace was initialized,
         kXMPErrWrongType is thrown. Note that the keys and values
         returned are pointers to internal structure and are READ-ONLY */

   XMPVMethod void         First(XMPISOStr* key, XMPPtr* value, XMPULong* valueLength)
      = 0;
// XMPMethod void       First(XMPOSType* key, XMPPtr* value)
//    = 0;
// XMPMethod void       First(XMPSLong* key, XMPPtr* value)
//    = 0;
   XMPVMethod void         Next(XMPISOStr* key, XMPPtr* value, XMPULong* valueLength)
      = 0;
// XMPMethod void       Next(XMPOSType* key, XMPPtr* value)
//    = 0;
// XMPMethod void       Next(XMPSLong* key, XMPPtr* value)
//    = 0;
   XMPVMethod XMPBoolean   IsNotComplete()
      = 0;
};

#ifndef _NMSPCITM_
#include "NmSpcItM.h"
#endif

#endif // _NMSPCITR_
