/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    NamSpacM.h

   Contains:   XMPMacNameSpace, XMPMacNameSpaceManager, XMPMacValueIterator
            class definitions.

   Written by: Nick Pilch

   Copyright:   1993 by Apple Computer, Inc., all rights reserved.

   Change History (most recent first):

      <24>    2/9/94 NP    Tiger Team cleanup.
      <23>    2/3/94 CG    Added fHeap.
      <22>   1/29/94 NP    Init changes.
      <21>   1/18/94 CG    Added valueLen parameter to GetValue().
      <20>   1/14/94 CG    Iterator and NameSpaceManager break out.
      <19>   1/12/94 CG    Made UpdatePreferences a public method.
      <18>   1/11/94 T    Init... changes
      <17>  12/17/93 eeh      added GetRegLibFileFolder
      <16>  12/15/93 T    more InitObject changes, remove
                           Initialize() method
      <15>  11/18/93 CG    Changed prefs file format, mapping rez
                           format.  Fixed bugs.
      <14>  11/15/93 NP    Changed XMPSymbols to XMPNameSpaceManager
                           and added a methods to XMPNameSpace.
      <13>  11/12/93 CG    Removed WriteNameSpace and changed fPrefs
                           to be a XMPFile*.
      <12>   11/8/93 NP    Added WriteToStorage and ReadFromStorage.
      <11>   11/8/93 NP    Changed signature of WriteToFile and
                           ReadFromFile.
      <10>   11/5/93 NP    Added WriteToFile and ReadFromFile.
       <9>  10/28/93 NP    Comment out obsoleted parts of API. Will
                           remove later.
       <8>  10/22/93 NP    Removed valueLength parameter for XMPSLong
                           and XMPOSType methods-it was never used.
       <7>  10/18/93 CG    Removed #ifdef ASLMBuild to prevent
                           touching this file unnecessarily.
       <6>   10/7/93 CG    Added pref handling methods.
       <5>   10/5/93 CG    Added Exists method to XMPMacNameSpace.
       <4>   9/21/93 CG    Added namespace table loading methods.
       <3>    8/9/93 NP    Added class id string.
       <2>   7/21/93 NP    Changed FirstNextAux method of
                           XMPValueIterator.
       <1>    7/2/93 NP    first checked in
      <11>   6/22/93 NP    Reverted iterator semantics to orginal.
                           Added comments.
      <10>   6/14/93 NP    Implemented inheritance.
       <9>    6/4/93 NP    Changed iterator semantics. Fixed comments.
       <8>    6/2/93 NP    Interface and comment changes as per
                           discussion with Kurt.
       <7>   5/18/93 NP    Updated HasNameSpace.
       <6>   4/28/93 NP    File name changes.
       <5>   4/28/93 NP    Added Initialize and Purge.
       <4>   4/23/93 NP    XMPHashTable -> XMPAEHashTable.
       <3>   4/23/93 NP    Added Initialize and Purge.
       <2>   4/23/93 NP    Changed XMPMacValueIterator::IsComplete to
                           XMPMacValueIterator::IsNotComplete.
       <1>   4/13/93 NP    first checked in

   To Do:
*/

#ifndef _NAMSPACM_
#define _NAMSPACM_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _AEHSHTBL_
#include "AEHshTbl.h"
#endif

//==============================================================================
// Constants
//==============================================================================

const XMPULong    kNumExpectedEntries = 10; //??-cg
const XMPOSType      kASLMCreator = 'OMGR';

//==============================================================================
// Local Function Prototypes
//==============================================================================

void ReadBytes(XMPFileRefNum file, XMPStorageUnitView* view,
                  XMPPtr bytes, XMPULong* length);
XMPULong ReadSize(XMPFileRefNum file, XMPStorageUnitView* view);


//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacNameSpace;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPMacNameSpaceManager;
class XMPSession;
class XMPAEHashTable;
class XMPAEHashTableIterator;
class XMPStringHashTable;
class XMPStringHashTableIterator;

//==============================================================================
// XMPMacNameSpace
//==============================================================================

#define kXMPMacNameSpaceID "appl:xmpmacnamespace$class,1.0.0"

class XMPMacNameSpace : public XMPAbsNameSpace
{
  public:

   XMPVMethod XMPISOStr GetName();

   XMPVMethod void      Register(XMPISOStr key, XMPPtr value, XMPULong valueLength);
// XMPVMethod void      Register(XMPOSType key, XMPPtr value);
// XMPVMethod void      Register(XMPSLong key, XMPPtr value);

   XMPVMethod void      Unregister(XMPISOStr key);
// XMPVMethod void      Unregister(XMPOSType key);
// XMPVMethod void      Unregister(XMPSLong key);

   XMPVMethod XMPBoolean   GetValue(XMPISOStr key, XMPPtr* value, XMPULong* valLen);
// XMPVMethod XMPBoolean   GetValue(XMPOSType key , XMPPtr* value);
// XMPVMethod XMPBoolean   GetValue(XMPSLong key , XMPPtr* value);

   XMPVMethod XMPBoolean   Exists(XMPISOStr key);
// XMPVMethod XMPBoolean   Exists(XMPOSType key);
// XMPVMethod XMPBoolean   Exists(XMPSLong key);

   XMPVMethod void         WriteToFile(XMPFileRefNum file);

   XMPVMethod void         ReadFromFile(XMPFileRefNum file);

   XMPVMethod void         WriteToStorage(XMPStorageUnitView* view);

   XMPVMethod void         ReadFromStorage(XMPStorageUnitView* view);

   XMPVMethod XMPSize      Purge(XMPSize size);

  public: // private. used only by XMPValueIterator.

   XMPNVMethod XMPNSTypeSpec        GetType();
   XMPNVMethod XMPStringHashTable*     GetStringHashTable();
   XMPNVMethod XMPAEHashTable*         GetAEHashTable();

  private:

   XMPNVMethod void              Register32BitsAux(KeyPtr key, 
                                    HEntryPtr value);
   XMPNVMethod void              Unregister32BitsAux(KeyPtr key);
   XMPNVMethod void              Write(XMPFileRefNum file,
                                    XMPStorageUnitView* view);
   XMPNVMethod void              Read(XMPFileRefNum file,
                                    XMPStorageUnitView* view);
   XMPULong                   GetNumEntries();

   XMPISOStr            fName;
   XMPAEHashTable*         fAEHashTable;
   XMPStringHashTable*     fStringHashTable;
   XMPNSTypeSpec        fType;
   XMPNameSpaceManager* fNameSpaceManager;
   XMPNameSpace*        fParent;
   XMPULong          fNumInitialEntries;
   XMPHeap              fHeap;

  public: // private by convention

   XMPMacNameSpace();

   XMPNVMethod void InitNameSpace(XMPNameSpaceManager*   mgr,
                           XMPNameSpace*     parent,
                           XMPULong       numExpectedEntries,
                           XMPISOStr         name, 
                           XMPHeap           heap);
   XMPVMethod ~XMPMacNameSpace();
   
   void           NotifyDying(XMPNameSpace* space);
};

#endif // _NAMSPACM_
