/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    NamRslvr.h

   Contains:   XMPNameResolver class.

   Written by: Nick Pilch

*/

#ifndef _NAMRSLVR_
#define _NAMRSLVR_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsNameResolver;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPPart;
class XMPFrame;

//==============================================================================
// Structures used by this interface
//==============================================================================

class XMPOSLToken;

//==============================================================================
// XMPAbsNameResolver
//==============================================================================

class XMPAbsNameResolver : public XMPObject
{
  public:

   XMPVMethod void         Resolve(XMPObjectSpec*        theObject, 
                            XMPOSLToken*  token,
                            XMPPart*      contextPart) 
      = 0;

   XMPVMethod void         CreateSwapToken(XMPOSLToken*  token,
                                       XMPFrame*   frame)
      = 0;
   
   XMPVMethod void         CreateToken(XMPOSLToken*      token,
                              DescType       type,
                              XMPPart*       inPart)
      = 0;

   XMPVMethod XMPFrame* GetContainingFrame()
      = 0;

   XMPVMethod void         GetContextInfo(XMPFrame** frame, XMPPart** part)
      = 0;

   XMPVMethod void         CallObjectAccessor(
                                    XMPPart*    part,
                                    DescType    desiredClass,
                                    XMPOSLToken*   containerToken,
                                    DescType    containerClass,
                                    DescType    keyForm,
                                    AEDesc*        keyData,
                                    XMPOSLToken*   token)
      = 0;

   XMPVMethod void         DisposeToken(XMPOSLToken* theToken) 
      = 0;

   XMPVMethod XMPSize      Purge(XMPSize howMuch) 
      = 0;
   
  public: // Private by convention

   XMPAbsNameResolver() {}
   XMPVMethod ~XMPAbsNameResolver() {}
};

#ifdef PLATFORM_MACINTOSH
#ifndef _NAMRSLVM_
#include "NamRslvM.h"
#endif
#endif

#endif // _NAMRSLVR_
