/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    MssgIntM.h

   Contains:   Mac implementation of messaging system class interface.

   Written by: Caia Grisar

*/

#ifndef _MSSGINTM_
#define _MSSGINTM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _SEMTINTF_
#include "SemtIntf.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPMacMessageInterface;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPPart;
class XMPShape;
class XMPSETransactionList;
class XMPSession;
class XMPNameResolver;

//==============================================================================
// XMPMessageInterface
//==============================================================================

#define kXMPMacMessageInterfaceID "appl:xmpmacmessageinterface$class,1.0.0"

class XMPMacMessageInterface : public XMPAbsMessageInterface
{
  public:

   XMPVMethod XMPSShort       CreateEvent(AEEventClass   theAEEventClass,
                              AEEventID      theAEEventID,
                              AEAddressDesc* target,
                              XMPSLong    transactionID,
                              AppleEvent*    result);

   XMPVMethod void CreatePartAddrDesc(AEDesc*      theAddressDesc,
                                 XMPPart* thePart);

   XMPVMethod void CreatePartObjSpec(AEDesc* theObjSpec, XMPPart* thePart);

   XMPVMethod void            Send(XMPPart*              thePart,
                           AppleEvent*          theAppleEvent,
                           AppleEvent*          reply,
                           AESendMode           sendMode,
                           AESendPriority       sendPriority,
                           XMPULong          timeOutInTicks,
                           XMPIdleProcPtr       idleProc,
                           XMPEventFilterProcPtr   filterProc);

   XMPVMethod XMPBoolean   ProcessSemanticEvent(XMPEventData theEvent);
   
   XMPVMethod XMPSize      Purge(XMPSize howMuch);

   // <eeh> made public for Move event.  Is there another way?
   // <NP> Yes. Call Send.
   OSErr DispatchToEventHandler(AppleEvent*  message,
                                 AppleEvent* reply,
                                 XMPPart* contextPart);

  public: // Private by convention

   XMPMacMessageInterface();
   XMPVMethod ~XMPMacMessageInterface();
   XMPNVMethod void InitMessageInterface(XMPSession* session);
   
  private:

   static OSErr pascal  HandleAllSEvents(AppleEvent* message,
                                 AppleEvent* reply,
                                 long refCon);
   OSErr          HandleAllSEventsAux(AppleEvent* message,
                                 AppleEvent* reply);

   static OSErr pascal  HandleReplies(AppleEvent* message,
                                 AppleEvent* reply,
                                 long refCon);
   OSErr          HandleRepliesAux(AppleEvent* message,
                                 AppleEvent* reply);

   static OSErr pascal HandleAllCoercions(   AEDesc      theAEDesc,
                                 DescType toType,
                                 long     refCon,
                                 AEDesc*     retDesc);
   OSErr             HandleAllCoercionsAux(  AEDesc      theAEDesc,
                                    DescType toType,
                                    AEDesc*     retDesc);
   OSErr    DispatchToCoercionHandler(AEDesc theAEDesc, DescType toType,
                              XMPPart* sendee, AEDesc* retDesc);

   OSErr DispatchEventWithToken(XMPOSLToken* token,
                           AppleEvent* message,
                           AppleEvent* reply,
                           XMPBoolean  usingSubjectAttr);
// OSErr DispatchToEventHandler(AppleEvent*  message,
//                               AppleEvent* reply,
//                               XMPPart* contextPart);
   OSErr DispatchToEventHandlerAux(AppleEvent* message, AppleEvent* reply,
                              XMPPart* sendee);
   OSErr GiveShellATry(AppleEvent* message, AppleEvent* reply, OSErr error);
#if 0
   static pascal OSErr HandleListCoercions(AEDesc     theAEDesc,
                                 DescType toType,
                                 long     handlerRefCon,
                                 AEDesc*     retDesc);
   OSErr             HandleListCoercionsAux( AEDesc      theAEDesc,
                                    DescType toType,
                                    AEDesc*     retDesc);

   static pascal OSErr HandleRecordCoercions(   AEDesc      theAEDesc,
                                    DescType toType,
                                    long     handlerRefCon,
                                    AEDesc*     retDesc);
   OSErr             HandleRecordCoercionsAux(  AEDesc      theAEDesc,
                                       DescType toType,
                                       AEDesc*     retDesc);
#endif // 0
  private:
   
   XMPSETransactionList*   fTransactionList;
   XMPSShort            fNextReturnID;
   XMPSession*          fSession;
   XMPNameResolver*     fNameResolver;
};

#endif // _MSSGINTM_
