/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    MssgIntf.h

   Contains:   Messaging system class interface.

   Written by: Nick Pilch

*/

#ifndef _MSSGINTF_
#define _MSSGINTF_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsMessageInterface;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPObject;
class XMPPart;
class XMPShape;
class XMPSETransactionList;
class XMPSession;

//==============================================================================
// Scalar Types
//==============================================================================

typedef XMPBoolean (*XMPIdleProcPtr)(XMPPart*         thePart,
                              XMPEventData*  theEventRecord,
                              XMPULong    sleepTime,
                              XMPShape    mouseRgn);

typedef XMPBoolean (*XMPEventFilterProcPtr)(XMPPart*     thePart,
                                 XMPEventData*  theEventRecord,
                                 XMPSLong    returnID,
                                 XMPSLong    transactionID,
                                 AEAddressDesc  sender);
#if 0
struct XMPNotificationRecord; // forward declaration

typedef void (*XMPNotificationResponseProcPtr)
               (XMPPart*               thePart,
                  XMPNotificationRecord*  notificationRecord);

struct XMPNotificationRecord
{
   XMPUShort                  itemToMark;       /*item to mark in menu*/
   XMPIcon                    icon;          /*handle to small icon*/
   XMPSound                sound;         /*handle to sound record*/
   XMPName                    alertString; /*string to appear in alert*/
   XMPNotificationResponseProcPtr   responseFunction; /*pointer to response routine*/
   XMPSLong                refCon;           /*for application use*/
};
#endif // 0
//==============================================================================
// XMPMessageInterface
//==============================================================================

class XMPAbsMessageInterface : public XMPObject
{
  public:

   XMPVMethod void CreatePartAddrDesc(AEDesc*      theAddressDesc,
                                 XMPPart* part)
      =0;
      
   XMPVMethod void CreatePartObjSpec(AEDesc* theObjSpec, XMPPart* thePart)
      =0;
      
   XMPVMethod XMPSShort       CreateEvent(AEEventClass   theAEEventClass,
                              AEEventID      theAEEventID,
                              AEAddressDesc* target,
                              XMPSLong    transactionID,
                              AppleEvent*    result) 
      = 0;

   XMPVMethod void            Send(XMPPart*              part,
                           AppleEvent*          theAppleEvent,
                           AppleEvent*          reply,
                           AESendMode           sendMode,
                           AESendPriority       sendPriority,
                           XMPULong          timeOutInTicks,
                           XMPIdleProcPtr       idleProc,
                           XMPEventFilterProcPtr   filterProc) 
      = 0;

   XMPVMethod XMPBoolean   ProcessSemanticEvent(XMPEventData theEvent) 
      = 0;
   
   XMPVMethod XMPSize      Purge(XMPSize howMuch) 
      = 0;

  public: // Private by convention

   XMPAbsMessageInterface(){}
   XMPVMethod ~XMPAbsMessageInterface(){}
};

#ifdef PLATFORM_MACINTOSH
#ifndef _MSSGINTM_
#include "MssgIntM.h"
#endif
#endif

#endif // _MSSGINTF_
