/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    MenuBar.h

   Contains:   Interface to XMPMenuBar class

   Written by: Richard Rodseth

*/

// MenuBar.h

#ifndef _MENUBAR_
#define _MENUBAR_

#ifndef _REFCTOBJ_
#include "RefCtObj.h"
#endif   

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPMenuBar; 

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPPart;

//=====================================================================================
// Class XMPAbsMenuBar
//=====================================================================================

class XMPAbsMenuBar : public XMPRefCntObject
{
public:
   XMPAbsMenuBar() {}
   XMPVMethod ~XMPAbsMenuBar() {}
   
   XMPVMethod void   Release()
      = 0;
      
   XMPVMethod void Display()
      = 0;

   XMPVMethod XMPMenuBar* Copy()
      = 0;  

   XMPVMethod void AddMenuLast(XMPMenuID menuID, XMPPlatformMenu menu, XMPPart* part)
      = 0;

   XMPVMethod void AddMenuBefore(XMPMenuID menuID, 
                          XMPPlatformMenu menu, 
                          XMPPart* part, 
                          XMPMenuID beforeID)
      = 0;
      
   XMPVMethod void RemoveMenu(XMPMenuID menu)
      = 0;  

   XMPVMethod XMPPlatformMenu GetMenu(XMPMenuID menu)
      = 0;  

};

#ifdef PLATFORM_MACINTOSH
#ifndef _MENUBARM_
#include "MenuBarM.h"
#endif
#endif

#endif // _MENUBAR_
