/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    MemCtr.h

  Contains:  Definition of XMPMemoryContainer

  Written by:  Paul Hartenstine

*/

#ifndef _MEMCTR_
#define _MEMCTR_

#ifndef _BENTOCTR_
#include "BentoCtr.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _BENTOHDR_
#include "BentoHdr.h"
#endif

#ifndef _DOCUMENT_
#include "Document.h"      // included for XMPDocumentID
#endif

#ifndef __CM_API__
#include "CMAPI.h"
#endif

#ifndef __CM_API_TYPES__
#include "CMAPITyp.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
  A Container represents a physical collection of bytes, like a file or a
  section of memory.  This particular container is a block of memory.
    
  XMPContainer objects are created through XMPStorageSystem object either by
  XMPStorageSystem::GetContainer or XMPStorageSystem::NewContainer. 
  XMPStorageSystem::NewContainer should does an implicit 
  XMPStorageSystem::GetContainer.
  
  Access to Container is not guaranteed to be exclusive.
  
  For every XMPStorageSystem::GetContainer there should be a paranthetically 
  correct XMPStorageSystem::ReleaseContainer.
    
  In Exemplar v1, there is only one Exemplar Document per Container.  
  
  A XMPContainer object is responsible for guaranteeing that multiple accesses
  to a Document use the same XMPDocument object.
*/

//==============================================================================
// Classes used by this interface
//==============================================================================
class  XMPStorageSystem; 

//==============================================================================
// Classes defined in this interface
//==============================================================================
class  XMPMemoryContainer;

//==============================================================================
// XMPMemoryContainer
//==============================================================================

class XMPMemoryContainer : public XMPBentoContainer {

public:  // private by convention

  XMPMemoryContainer();
          
    // Returns an uninitialized XMPContainer object. 
    // Initialize should be called immediately after this function.
    
  virtual ~XMPMemoryContainer();
  
    // Closes the container in persistent storage if it is still open.

  XMPMethod void InitContainer(XMPStorageSystem* storage, XMPContainerID id);

    // OVERRIDE
    // Called after constructor

  XMPMethod XMPContainer* Create();  
    // Creates a container in persistent storage
      
  XMPMethod XMPContainer* Open();
  
    // Opens container in persistent storage        
  
  XMPMethod XMPContainer* Close();
  
    // Closes container in persistent storage      

  XMPMethod XMPSize Purge(XMPSize size);    
  
    // OVERRIDE
    // Gets rid of any unnecessary memory by purging memory blocks
    //  or flushing structures out to disk

};


#endif  // _MEMCTR_
