/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    MacTypes.h

  Version:  System 7.1 for ETO #11
  Created:  Tuesday, March 30, 1993 18:00

*/

#ifndef __MACTYPES__
#define __MACTYPES__

#include <os2.h>

// KLS: get rid of pascal keyword
#define pascal

#ifndef SystemSevenOrLater
#define SystemSevenOrLater 0
#endif

#ifndef SystemSixOrLater
#define SystemSixOrLater SystemSevenOrLater
#endif

#ifndef NULL
#define NULL 0
#endif
#define nil 0

#define noErr 0      /*All is well*/

typedef unsigned char Byte;
typedef char SignedByte;
typedef char *Ptr;
typedef Ptr *Handle;  /*  pointer to a master pointer */

typedef long Fixed;    /* fixed point arithmatic type */
typedef Fixed *FixedPtr;
typedef long Fract;
typedef Fract *FractPtr;


#if 1   // KLS: def mc68881
struct extended80 {
 short w[5];
};
typedef struct extended80 extended80;

#else
typedef extended extended80;

#endif

enum {false,true};
//typedef unsigned char Boolean;

enum {v,h};
typedef unsigned char VHSelect;


typedef long (*ProcPtr)();
typedef ProcPtr *ProcHandle;

typedef unsigned char Str255[256],Str63[64],Str32[33],Str31[32],Str27[28],Str15[16],*StringPtr,**StringHandle;

#ifdef __cplusplus
inline unsigned char & Length(StringPtr string) { return (*string); }
#else
#define Length(string) (*(unsigned char *)(string))
#endif

typedef const unsigned char *ConstStr255Param;
typedef ConstStr255Param ConstStr63Param,ConstStr32Param,ConstStr31Param,
 ConstStr27Param,ConstStr15Param;

typedef short OSErr;  /* error code */
typedef unsigned long OSType;
typedef OSType *OSTypePtr;
typedef unsigned long ResType;
typedef ResType *ResTypePtr;
typedef unsigned char Style;
typedef short ScriptCode;
typedef short LangCode;


//struct Point {
// short v;
// short h;
//};

//typedef struct Point Point;

//struct Rect {
// short top;
// short left;
// short bottom;
// short right;
//};

//typedef struct Rect Rect;

enum {
 normal = 0,
 bold = 1,
 italic = 2,
 underline = 4,
 outline = 8,
 shadow = 0x10,
 condense = 0x20,
 extend = 0x40
};


#ifdef __cplusplus
extern "C" {
#endif
pascal void Debugger(void);
pascal void DebugStr(ConstStr255Param aStr);
void debugstr(char *aStr);
pascal void SysBreak(void);
pascal void SysBreakStr(ConstStr255Param debugStr);
pascal void SysBreakFunc(ConstStr255Param debugFunc);
#ifdef __cplusplus
}
#endif




// MAC HEADERS

//Yansheng's modification
typedef  BOOL   Boolean;      // ??  Expected ; or ,
// typedef  short     Fixed;     // ??
typedef  int       Region;
typedef  int       RgnPtr;
//#define  RgnHandle HRGN

typedef  HRGN       RgnHandle;
// typedef  int       FSSpec;
// typedef  int       ScriptCode;     // ??
typedef  int       TMemoryPool;
// typedef  int       ProcessSerialNumber;
// typedef  int       OSType;          // ??
typedef  int       WindowPrt;
typedef  HPS       GrafPtr;
// typedef  int       EventRecord;
// typedef  int       MenuHandle;
// typedef  int       Handle;          // ??
typedef  int       IntlText;
typedef  int       WindowPtr;
// typedef  int       AEDesc;

typedef POINTL Point;
typedef RECTL Rect;
typedef Point *PointPtr;
typedef Rect *RectPtr;


#endif


