/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    LinkSpec.h

   Contains:   Class definition for XMPAbsLinkSpec.

   Written by: Craig Carper 

*/

#ifndef _LINKSPEC_
#define _LINKSPEC_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Theory of Operation
//=====================================================================================

/*
   LinkSpecs are created by a part to indicate that content may be pasted as a link.
   A part advertises the ability to source a link by calling its draft to create a
   link spec and then putting that link spec on the clipboard (in a standard property
   in the root storage unit of the clipboard).  Once it has created the link spec,
   the source part should call CopyToProperty() to write the link spec as a value,
   after focusing the clipboard storage unit to the appropriate property.  The 
   receiving part should create a LinkSpec object and call CopyFromProperty() to
   initialize the object from the clipboard storage unit.  The receiving part calls
   its draft's GetLink() method to get the actual link from the LinkSpec.
*/

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPAbsLinkSpec;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPStorageUnit;

//==============================================================================
// XMPAbsLinkSpec
//==============================================================================

class XMPAbsLinkSpec
{
public:

   // ----------------------------------------
   // Parts may call

   XMPAbsLinkSpec() {};
   
   XMPVMethod ~XMPAbsLinkSpec() {};
   
   XMPVMethod void WriteToProperty(XMPStorageUnit* su)
      = 0;

      // Write this object into the pre-focused storage unit.
      // The argument storage unit must be pre-focused to a property.
   
   XMPVMethod void ReadFromProperty(XMPStorageUnit* su)
      = 0;

      // Initialize this object from the value in the pre-focused storage unit.
      // The argument storage unit must be pre-focused to a property containing
      // a link spec value.

};

#ifndef _LINKSPEM_
#include "LinkSpeM.h"
#endif

#endif
