/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    ISOStr.h

  Contains:  Routines to manipulate XMPISOStr

  Written by:  Steve Smith, Vincent Lo.

*/

/************************************************************

  ISOString.h
  ISO String handling
  
  Copyright Apple Computer,Inc. 1993
  All rights reserved

************************************************************/


#ifndef _ISOSTR_
#define _ISOSTR_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif


XMPISOStr  XMPISOStrCopy (XMPISOStr dest, const XMPISOStr source);
XMPISOStr  XMPISOStrCopy (XMPISOStr dest, const XMPISOStr source, XMPULong length);
XMPISOStr  XMPISOStrConcat (XMPISOStr dest, const XMPISOStr source);
XMPISOStr  XMPISOStrConcat (XMPISOStr dest, const XMPISOStr source, XMPULong length);
XMPSLong  XMPISOStrCompare (const XMPISOStr iso1, const XMPISOStr iso2);
XMPSLong  XMPISOStrCompare (const XMPISOStr iso1, const XMPISOStr iso2, XMPULong length);
XMPBoolean  XMPISOStrEqual (const XMPISOStr iso1, const XMPISOStr iso2);
XMPULong  XMPISOStrLength (const XMPISOStr iso);
XMPISOStr  XMPISOStrFromCStr(const char* cstring);


#endif // _ISOSTR_
