/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    IndHdr.h

  Contains:  Header for indirect values.

  Written by:  Vincent Lo

*/

#ifndef _INDHDR_
#define _INDHDR_

#ifndef __CM_API__
#include "CMAPI.h"
#endif

#ifndef __CM_API_ENVIRONMENT__
#include "CMAPIEnv.h"
#endif


//==============================================================================
// Constants
//==============================================================================

extern const CMGlobalName kXMPIndirectValueGlobalName ; // = "OpenDoc:IndirectValue";
extern const XMPType  kXMPEmbeddedContainerProperty; // = "OpenDoc:EmbeddedContainer";
extern const XMPType  kXMPEmbeddedContainerType; // = "OpenDoc:EmbeddedContainerType";
                            //jpa: Can't define in .h file

//==============================================================================
// Function Prototype
//==============================================================================

  CM_CFUNCTIONS

CMHandlerAddr CM_FIXEDARGS IndirectDynamicValueMetahandler(CMType targetType,
                    CMconst_CMGlobalName operationType);

  CM_END_CFUNCTIONS

#endif
