/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    IdleList.h

   Contains:   Interface to IdleInfo, IdleList and IdleListIterator classes.

   Written by: Richard Rodseth

*/

#ifndef _IDLELIST_
#define _IDLELIST_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _LIST_
#include "List.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

typedef XMPULong XMPTicks; 

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class IdleInfo; 
class IdleList;            
class IdleListIterator;          

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPFrame;
class XMPPart;

//=====================================================================================
// Global Variables
//=====================================================================================

//======================================================================================
// Class IdleInfo
//======================================================================================

class IdleInfo : public Link
{
public:
   IdleInfo(XMPPart* part, XMPFrame* frame, XMPIdleFrequency frequency);
   virtual ~IdleInfo();

   XMPBoolean NeedsIdle(XMPTicks ticks);
   XMPTicks NextIdle(XMPTicks ticks);
   
   XMPPart* GetPart() { return fPart; }
   XMPFrame* GetFrame() { return fFrame; }
   XMPIdleFrequency GetIdleFrequency() { return fIdleFrequency; }
   void SetIdleFrequency(XMPIdleFrequency frequency) { fIdleFrequency = frequency; }
   XMPTicks GetLastIdle() { return fLastIdle; }
   void SetLastIdle(XMPTicks lastIdle) { fLastIdle = lastIdle; }

private: 
   XMPPart*       fPart;
   XMPFrame*         fFrame;
   XMPIdleFrequency  fIdleFrequency;
   XMPSLong          fLastIdle;
};

//=====================================================================================
// IdleList
//=====================================================================================

class IdleList
{
   friend class IdleListIterator;
   
public:
   IdleList();
   virtual ~IdleList();
   
   void AddIdle(XMPPart* part, XMPFrame* frame, XMPIdleFrequency frequency); 
   
   void RemoveIdle(XMPPart* part, XMPFrame* frame); 
   
   void SetIdleFrequency(XMPPart* part, XMPFrame* frame, XMPIdleFrequency frequency); 

private:
   LinkedList fImplementation;
};

//=====================================================================================
// IdleListIterator
//=====================================================================================

class IdleListIterator
{
public:

   IdleListIterator(IdleList* idleList);
   
      // Constructor
      
   XMPVMethod ~IdleListIterator();
   
      // Destructor
   
   XMPMethod IdleInfo* First();
   
      // Returns the first element of the set
      
   XMPMethod IdleInfo* Next();
   
      // Returns the next element in the set
      
   XMPMethod XMPBoolean IsNotComplete();
   
      // Returns TRUE as long as there are more elements in the set
   
private:
   
   LinkedListIterator fIterator;
   
};

#endif // _IDLELIST_
