/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    FSHdr.h

  Contains:  XMPFSContainer header

  Written by:  Vincent Lo

*/

#ifndef _FSHDR_
#define _FSHDR_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _BENTOHDR_
#include "BentoHdr.h"
#endif

#ifndef __CM_API__
#include "CMAPI.h"
#endif

#ifndef __CM_API_TYPES__
#include "CMAPITyp.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Constants
//==============================================================================

extern const XMPType  kXMPBentoFileTypeName; // = "FileCtr";

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================
class XMPFSBentoHandlers;

//==============================================================================
// Classes used by this interface
//==============================================================================
class XMPFile;

//==============================================================================
// XMPFSBentoHandlers
//==============================================================================

class XMPFSBentoHandlers : public XMPBentoHandlers
{
public:

  XMPFSBentoHandlers(CMSession session, XMPFile* file);
  XMPVMethod ~XMPFSBentoHandlers();
  
  XMPMethod void Initialize();
  XMPMethod CMSession GetCMSession();
  
  XMPMethod CMRefCon OpenHandler(CMOpenMode mode);
  XMPMethod void CloseHandler();
  XMPMethod CMSize FlushHandler();
  XMPMethod CMSize SeekHandler(CM_LONG posOff, CMSeekMode mode);
  XMPMethod CMSize TellHandler();
  XMPMethod CMSize ReadHandler(CMPtr buffer, CMSize elementSize, CMCount theCount);
  XMPMethod CMSize WriteHandler(CMPtr buffer, CMSize elementSize, CMCount theCount);
  XMPMethod CMEofStatus EOFHandler();
  XMPMethod CMBoolean TruncHandler(CMSize containerSize);
  XMPMethod CMSize ContainerSizeHandler();
  XMPMethod void ReadLabelHandler(CMMagicBytes magicByteSequence,
            CMContainerFlags *flags, CM_USHORT *bufSize,
            CM_USHORT *majorVersion, CM_USHORT *minorVersion,
            CMSize *tocOffset, CMSize *tocSize);
  XMPMethod void WriteLabelHandler(CMMagicBytes magicByteSequence,
            CMContainerFlags flags, CM_USHORT bufSize,
            CM_USHORT majorVersion, CM_USHORT minorVersion,
            CMSize tocOffset, CMSize tocSize);
  XMPMethod CMValue ReturnParentValueHandler();
  XMPMethod CM_UCHAR* ReturnContainerNameHandler();
  XMPMethod CMType ReturnTargetTypeHandler(CMContainer container);
  XMPMethod void ExtractDataHandler(CMDataBuffer buffer,
              CMSize size, CMPrivateData data);
  XMPMethod void FormatDataHandler(CMDataBuffer buffer,
              CMSize size,
              CMPrivateData data);

private:

  CMSession  fSession;
  XMPFile*  fFile;
  XMPBoolean  fHaveSize;
  XMPBoolean  fSeekValid;
  XMPSLong  fLastSeekOffset;
  XMPSShort  fLastSeekMode;
  CMSize    fFileSize;
};

#endif // _FSHDR_
