/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    FocusMod.h

   Contains:   Interface to XMPFocusModule class.

   Written by: Richard Rodseth

*/

#ifndef _FOCUSMOD_
#define _FOCUSMOD_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPFocusModule;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPSession;
class XMPFrame;
class XMPFocusOwnerIterator;

//=====================================================================================
// Class XMPFocusModule
//=====================================================================================

class XMPFocusModule
{
public:

   XMPFocusModule();
   
   XMPVMethod ~XMPFocusModule();
   
   XMPNVMethod void InitFocusModule(XMPSession* session);
   
   XMPVMethod XMPBoolean IsFocusExclusive(XMPTypeToken focus)
      = 0;
   
   XMPVMethod void SetFocusOwnership(XMPTypeToken focus, XMPFrame* frame)
      = 0;

   XMPVMethod void UnsetFocusOwnership(XMPTypeToken focus, XMPFrame* frame)
      = 0;
   
   XMPVMethod XMPFrame* GetFocusOwner(XMPTypeToken focus)
      = 0;
   
   XMPVMethod XMPFocusOwnerIterator* CreateOwnerIterator(XMPTypeToken focus)
      = 0;  

public: // Private to UI subsystem

   XMPMethod XMPBoolean BeginRelinquishFocus(XMPTypeToken focus, 
                                    XMPFrame* requestingFrame);
                      
   XMPMethod void CommitRelinquishFocus(XMPTypeToken focus,
                                 XMPFrame* requestingFrame);
                      
   XMPMethod void AbortRelinquishFocus(XMPTypeToken focus,
                                XMPFrame* requestingFrame);

protected:

   XMPSession* fSession;   // Access to globals
};

#endif // _FOCUSMOD_
