/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
#ifndef _FACETWIN_
#define _FACETWIN_

#include <icanvas.hpp>
#include <icmdhdr.hpp>          /* ICommandHandler             */
#include <ipainhdr.hpp>         /* IPaintHandler               */
#include <imchdr.hpp>           /* Mouse commands              */
#include <iexcbase.hpp>

#ifndef _FACET_
#include "facet.h"
#endif

#ifndef _DISPATCH_
#include "disptch.h"
#endif

typedef IEvent IWindowEvent;

class IWindowHandler : public IHandler
{
public:
   Boolean dispatchHandlerEvent(IEvent &);
};

class IFacetWindow : public IWindow, public IWindowHandler 
{
public:
   /* -------------------------------------------------------- */
   /* declare the constructor                                  */
   /* -------------------------------------------------------- */
   IFacetWindow( IWindow *parent
             , IWindow *owner
             , XMPFacet *Facet
             , const IRectangle &initialSize = IRectangle()
             , const Style &style = defaultStyle()
             );

   static Style defaultStyle        ( ) { return ( IWindow::visible |  IWindow::clipToParent) ; }   
   XMPFacet *GetXMPFacet();
   MRESULT windowEvent(IWindowEvent& evt);

protected:       

   static unsigned long CurWinID;
   XMPFacet *TheFacet;   //  Points to the facet this FacetWindow is associated with.
   XMPDispatcher *TheDispatcher;
};
#endif
