/********************************************************************/
/*  Licensed Materials - Property of IBM                            */
/*                                                                  */
/*                                                                  */
/* Copyright (C) International Business Machines Corp., 1994.       */
/* Copyright (C) Apple Computer, Inc., 1994                         */
/*                                                                  */
/*  US Government Users Restricted Rights -                         */
/*  Use, duplication, or disclosure restricted                      */
/*  by GSA ADP Schedule Contract with IBM Corp.                     */
/*                                                                  */
/********************************************************************/
/*
  File:    FacetM.h

  Contains:  Definition of class XMPMacFacet

  Written by:  Joshua Susser

  Copyright:   1993 by Apple Computer, Inc., all rights reserved.

  Change History (most recent first):

    <12>   2/16/94  JA    Stop including Point.h.
    <11>    2/3/94  JA    Tiger Team Makeover!
    <10>   1/24/94  SS    Checkin for Joshua (see below)
     <9+>   1/13/94  JBS    active border displays fActiveShape
                     added offscreen canvas support
     <9>   1/11/94  T    Init... changes
     <8>  12/21/93  JBS    InitFacet changes
     <7>  12/15/93  JBS    add fActiveShape & fWindow, plus accessors
     <6>   12/3/93  T    return XMPFacet* from CreateEmebeddedFacet
     <5>  11/19/93  PH    Add class id and fix for ASLM
     <4>  11/18/93  JBS    remove fWindow, add mouse tracking
     <3>  11/16/93  JBS    add child drawing and moving methods
     <2>  11/16/93  JBS    add fIsSelected, fHighlight
     <1>  11/12/93  JBS    first checked in
*/

#ifndef _FACETM_
#define _FACETM_

//JYS: Added Icanvas.hpp
//#include "icanvas.hpp"

#ifndef _FACET_
#include "Facet.h"
#endif
//=====================================================================================
// Theory of Operation
//=====================================================================================

/*
  Facets hold the ephemeral information associated with the display of
  a particular Frame.
*/

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPMacFacet;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPAbsFacet;
class XMPFacetIterator;
class FacetNode;
class List;
class NodeTraverser;
class XMPCanvas;
class XMPDragItemIterator;
class XMPFrame;
class XMPShape;
class XMPTransform;
class XMPWindow;

#ifdef OS2_FACET_AS_WINDOW
class IFacetWindow;
#endif

//=====================================================================================
// XMPFacet
//=====================================================================================

#define kXMPMacFacetID "appl:xmpmacfacet$class,1.0.0"

class XMPMacFacet : public XMPAbsFacet
{
  friend class XMPFacetIterator;

public:
  
  //---------------------------------
  // constructor

  XMPMacFacet();
      
  virtual ~XMPMacFacet();


#ifdef OS2_FACET_AS_WINDOW
  // JYS: added GetFacetWinHandle()  -- OS/2 specific
  HWND  GetFacetWinHandle();
#endif


  // JYS: Added an extra parameter to InitFacet 
  // Specify the HWND of this facet's parent window 
  XMPNVMethod void   InitFacet(XMPFrame* frame,
                  XMPShape* clipShape,
                  XMPTransform* externalTransform,
                  XMPFacet *ParentFacet);

  XMPVMethod XMPSize Purge(XMPSize size);
  
  //---------------------------------
  // frames

  XMPVMethod XMPFrame* GetFrame();

  XMPVMethod XMPFacet* CreateEmbeddedFacet(XMPFrame* frame,
              XMPShape* clipShape, XMPTransform* externalTransform,
              XMPFacet* siblingFacet, XMPFramePosition position);
    // Add a frame to my list of visible facets, creating a new Facet for it
        
  XMPVMethod void RemoveFacet(XMPFacet* facet);
    // Remove a facet which is no longer visible. 

  XMPVMethod void MoveBefore(XMPFacet* child, XMPFacet* sibling);
    // Move child facet to be in front of sibling.
    // If sibling is NULL, move child to front of all children.

  XMPVMethod void MoveBehind(XMPFacet* child, XMPFacet* sibling);
    // Move child facet to be in back of sibling.
    // If sibling is NULL, move child to back of all children.

  XMPVMethod XMPFacet* GetContainingFacet();
  
  XMPVMethod XMPFacetIterator* CreateFacetIterator(XMPTraversalType traversalType, 
                           XMPSiblingOrder siblingOrder);

  //---------------------------------
  // clip shape
  
  XMPVMethod XMPShape* GetClipShape();

  XMPVMethod void ChangeClipShape(XMPShape* clipShape);
    // set the value of my clip shape and notify my part

  XMPVMethod XMPShape* GetAggregateClipShape();
    // returns clipShape clipped to all containing
    // frames' clipShapes on facet's canvas

  XMPVMethod XMPShape* GetWindowAggregateClipShape();
    // returns clipShape clipped to all containing
    // frames' clipShapes in facet's window

  XMPVMethod void InvalidateAggregateClipShape();

  //---------------------------------
  // active shape
  
  XMPVMethod XMPShape* GetActiveShape();

  XMPVMethod void ChangeActiveShape(XMPShape* activeShape);
    // set the value of my active shape, notifying UI if necessary

  //---------------------------------
  // transformations:

  XMPVMethod XMPTransform* GetExternalTransform();

  XMPVMethod void ChangeExternalTransform(XMPTransform* transform);
    // if current fExternalTransform differs from new transform, then
    // invalidate the cached external and internal aggregate transforms
    // and also for all contained frames.

  XMPVMethod void InternalTransformChanged();
    // notify me that my frame's internalTransform changed
    // I need to invalidate my content transforms, and
    // my children's transforms as well

  XMPVMethod XMPTransform* GetFrameTransform();

  XMPVMethod XMPTransform* GetContentTransform();

  XMPVMethod XMPTransform* GetWindowFrameTransform();

  XMPVMethod XMPTransform* GetWindowContentTransform();

  XMPVMethod void InvalidateAggregateTransforms();

  //---------------------------------
  // canvas

  XMPVMethod XMPBoolean HasCanvas();
    // return whether this facet has its own canvas
    // (as opposed to using its parent's)

  XMPVMethod XMPCanvas* GetCanvas();
    // return my canvas.  if fCanvas is NULL, return my parent's canvas.

  XMPVMethod void SetCanvas(XMPCanvas* canvas);

//JYS: Added DisposeCanvas function for OS/2 implementation
  XMPVMethod void DisposeCanvas(XMPCanvas *canvas);
   // destroy the canvas object 

  //---------------------------------
  // window

  XMPVMethod XMPWindow* GetWindow();
    // return my frame's window

  XMPVMethod void SetWindow(XMPWindow* window);
    // only root facets should have a window
  //---------------------------------
  // PartInfo

  XMPVMethod XMPInfoType GetPartInfo();

  XMPVMethod void SetPartInfo(XMPInfoType partInfo);

  //---------------------------------
  // drag&drop

  XMPVMethod MRESULT DragEnter(XMPPoint point, XMPDragItemIterator* dragInfo);   //dwf
    // point in window coordinates

  XMPVMethod MRESULT DragWithin(XMPPoint point, XMPDragItemIterator* dragInfo);  //dwf
    // point in window coordinates

  XMPVMethod void DragLeave(XMPPoint point);
    // point in window coordinates

  XMPVMethod XMPDropResult Drop(XMPPoint point, XMPDragItemIterator* dropInfo);
    // point in window coordinates

  //---------------------------------
  // drawing

  XMPVMethod void Update(XMPShape* invalidShape);
    // draw any of (me + children) intersecting invalidShape

  XMPVMethod void Invalidate(XMPShape* invalidShape);
    // tell underlying graphics system to invalidate the area in invalidShape.
    // invalidShape is in my frame's coordinate system

  XMPVMethod void Validate(XMPShape* validShape);
    // tell underlying graphics system to validate the area in validShape.
    // validShape is in my frame's coordinate system

  XMPVMethod void Draw(XMPShape* invalidShape);
    // Asks my frame's part to draw its contents within my clipShape
    // clipped to the transformed invalidShape on my frame's canvas

  XMPVMethod void DrawChildren(XMPShape* invalidShape);
    // Draw all of my child facets which need updating, and all of their
    // children too.

  XMPVMethod void DrawChildrenAlways(XMPShape* invalidShape);
    // Force drawing of all of my child facets, and all of their children too.

  XMPVMethod void DrawnIn(XMPShape* shape);
    // mark shape as having been drawn in, but not in response to
    // an update event.  notify owner of canvas to update parent
    // canvas with altered contents

  XMPVMethod void InvalidateActiveBorder();

  XMPVMethod void DrawActiveBorder();

  //---------------------------------
  // mouse tracking and hit detection:

  XMPVMethod void MouseEnter(XMPPoint where);
    // Called when the mouse is moved over a facet (mouse button up)
    // Transform point to facet coords and pass to part

  XMPVMethod void MouseWithin(XMPPoint where);
    // Called when the mouse is moved within a facet (mouse button up)
    // Transform point to facet coords and pass to part
      
  XMPVMethod void MouseLeave();
    // Called when the mouse is moved out of a facet (mouse button up)

  XMPVMethod XMPBoolean ContainsPoint(XMPPoint point);
    // within activeShape ^ clipShape
    // point in window coordinate space

  XMPVMethod XMPBoolean ActiveBorderContainsPoint(XMPPoint point);
    // within active border shape
    // point in window coordinate space

  //---------------------------------
  // selection and highlighting:

  XMPVMethod XMPBoolean IsSelected();
    // return selection state

  XMPVMethod void SetSelected(XMPBoolean isSelected);
    // set selection state

  XMPVMethod XMPHighlight  GetHighlight();
    // return highlight state
  
  XMPVMethod void ChangeHighlight(XMPHighlight highlight);
    // Change the highlight state of this facet.

protected:

  XMPVMethod FacetNode* GetNode();

  XMPVMethod XMPBoolean NeedsUpdate();
  XMPVMethod void SetNeedsUpdate(XMPBoolean needsUpdate);
  XMPVMethod void ValidateBorderShape();
// JYS:
  HPS  GetHPS() ;
protected:

  XMPFrame*    fFrame;
  XMPShape*    fClipShape;
  XMPShape*    fActiveShape;
  XMPTransform*  fExternalTransform;
  XMPCanvas*    fCanvas;
  XMPWindow*    fWindow;
  XMPInfoType    fPartInfo;
  XMPBoolean    fIsSelected;
  XMPHighlight  fHighlight;

  FacetNode*    fNode;
  XMPBoolean    fNeedsUpdate;

  XMPShape*    fAggregateClipShape;
  XMPShape*    fWindowAggregateClipShape;
  XMPTransform*  fFrameTransform;
  XMPTransform*  fContentTransform;
  XMPTransform*  fWindowFrameTransform;
  XMPTransform*  fWindowContentTransform;

 //CED: Modification
  // Cache active border region to improve performance
  XMPShape*      fActiveBorderShape;
  XMPShape*      fActiveBorderMouseShape;
  XMPBoolean     fBorderShapeValid;
 
 //JYS: Modification
  //Facet will contain a pointer to PM Window object This is strictly OS/2
  //specific implementation and will not be exposed to the outside world.
  // cached values
  void     DisposeRegion(HRGN hrgn);
#ifdef OS2_FACET_AS_WINDOW
//private:
  IFacetWindow *TheFacetWindow; // Points to a real PM Widnow
  private:
  void        MoveWindowBefore(XMPFacet *child, XMPFacet *sibling);
  void        MoveWindowBehind(XMPFacet *child, XMPFacet *sibling);
#else
  HWND        GetClientWindow();
#endif

};

#endif // _FACETM_