/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    ErrorDef.h

   Contains:   Error codes for OpenDoc

   Written by: Vincent Lo

*/

/*
   This include file contains a list of all exception codes that can be
   signeled within OpenDoc. For now, the exception codes are just an 
   enumerated list. In the future, we may want to re-categorize them.
*/

#ifndef _ERRORDEF_
#define _ERRORDEF_

//==============================================================================
// Constants
//==============================================================================
      
#define kXMPErrUndefined               1
#define kXMPErrCannotResize               2
#define kXMPErrInvalidContainer           3
#define kXMPErrInvalidDocument            4
#define kXMPErrInvalidDraft               5
#define kXMPErrInvalidStorageUnit         6
#define kXMPErrCannotEmbed             7
#define kXMPErrInvalidPart             8
#define kXMPErrInvalidFrame               9
#define kXMPErrInvalidWindow           10
#define kXMPErrInvalidWindowState         11
#define kXMPErrInvalidSystemInterface     12
#define kXMPErrInvalidFocusSet            13
#define kXMPErrInvalidFocusModule         14
#define kXMPErrInvalidDispatchModule      15
#define kXMPErrInvalidType             16
#define kXMPErrTypeExists              17
#define kXMPErrInvalidName             18
#define kXMPErrNameExists              19
#define kXMPErrInvalidID               20
#define kXMPErrInvalidToken               21
#define kXMPErrInvalidExtension           22
#define kXMPErrInvalidValue               23
#define kXMPErrInvalidProperty            24
#define kXMPErrInvalidPosCode          25
#define kXMPErrInvalidValueIndex       26
#define kXMPErrKeyDoesNotExist            27
#define kXMPErrKeyAlreadyExists           28
#define kXMPErrWrongType               29
#define kXMPErrPartMissing             30
#define kXMPErrExtensionMissing           31
#define kXMPErrCannotAddProperty       32
#define kXMPErrCannotAddType           33
#define kXMPErrUnfocusedStorageUnit       34
#define kXMPErrInvalidPermissions         35
#define kXMPErrInvalidVersion          36
#define kXMPErrCannotCreateDraftVersion      37
#define kXMPErrInvalidBelowDraft       38
#define kXMPErrDraftNotExists          39
#define kXMPErrContainerExists            40
#define kXMPErrCannotCollapseDrafts       41
#define kXMPErrNonEmptyDraft           42
#define kXMPErrInvalidContainerType       43
#define kXMPErrContainerNotExists         44
#define kXMPErrDraftExistsWithDifferentID 45
#define kXMPErrNoPreviousDraft            46
#define kXMPErrInvalidPropertyName        47
#define kXMPErrInvalidSUCursor            48
#define kXMPErrVersionListInternalized    49
#define kXMPErrNoVersionList           50
#define kXMPErrNoDraftProperties       51
#define kXMPErrInvalidRefCount            52
#define kXMPErrCannotCreateFrame       53
#define kXMPErrCannotCreateWindow         54
#define kXMPErrCannotGetPersistentObject  55
#define kXMPErrOutstandingDraft           56
#define kXMPErrZeroRefCount               57
#define kXMPErrCannotCreateLayout         58
#define kXMPErrInvalidGraphicsSystem      59
#define kXMPErrSingularTransform       60
#define kXMPErrOutOfMemory             61
#define kXMPErrInvalidDraftID          62
#define kXMPErrVersionListUnavailable     63
#define kXMPErrSemaphoreReleased          64
#define kXMPErrCannotChangePermissions    65
#define  kXMPErrInvalidVersionList        66
#define  kXMPErrNameNotExists          67
#define  kXMPErrCannotGetFrame            68
#define  kXMPErrCannotCreatePart          69
#define  kXMPErrCannotGetPart          70
#define  kXMPErrCannotGetWindow           71
#define  kXMPErrCannotGetLayout           72
#define  kXMPErrInvalidStorageUnitRef     73
#define  kXMPErrInvalidIDList          74
#define  kXMPErrStorageUnitLocked         75
#define  kXMPErrInvalidStorageUnitKey     76
#define  kXMPErrStorageUnitNotLocked         77
#define kXMPErrBentoErr                78
#define kXMPErrBentoNoSession          79
#define kXMPErrBentoInvalidProperty       80
#define kXMPErrBentoInvalidType           81
#define kXMPErrBentoCannotNewObject       82
#define kXMPErrBentoCannotNewValue        83
#define kXMPErrBentoCannotCreateContainer 84
#define kXMPErrBentoCannotOpenContainer      85
#define  kXMPErrBentoInvalidObject        86
#define kXMPErrNotImplemented          87
#define kXMPErrIteratorOutOfSync          88
#define kXMPErrFocusAlreadyRegistered     89
#define kXMPErrFocusNotRegistered         90
#define kXMPErrFocusIsExclusive           91
#define kXMPErrFocusIsNonExclusive        92
#define kXMPErrUnknownWindow           93
#define kXMPErrNotPromise              94
#define kXMPErrCannotGetExternalLink      95
#define kXMPErrCannotCreateLink           96
#define kXMPErrNoLinkSpecValue            97
#define kXMPErrUnknownLinkSpecVersion     98
#define kXMPErrInvalidCanvas           99
#define kXMPErrCorruptLinkSpecValue       100
#define kXMPErrInvalidFacet               101
#define kXMPErrInvalidPositionCode        102
#define kXMPErrInvalidKey              103
#define kXMPErrReadErr                 104
#define kXMPErrWriteErr                105
#define kXMPErrNoDragManager           106
#define kXMPErrNoDragSystemStorage        107
#define kXMPErrDragItemNotFound           108
#define kXMPErrCannotAllocateDragItem     109
#define kXMPErrUnknownDragImageType       110
#define kXMPErrDragTrackingException      111
#define kXMPErrNoShapeGeometry            112      // Shape has no polygon representation
#define kXMPErrNotExportedLink            113
#define kXMPErrNotImportedLink            114
#define kXMPErrCannotGetLink           115
#define kXMPErrCannotInitializePart       116
#define kXMPErrInvalidTransform           117
#define kXMPErrInvalidLinkKey          118
#define kXMPErrDocNotSaved             119
#define kXMPErrCannotMarkAction           120
#define kXMPErrEmptyStack              121
#define kXMPErrNoBeginAction           122
#define kXMPErrCannotAddAction            123
#define kXMPErrInvalidPlatformWindow      124
#define kXMPErrShapeTooComplex            125      // Polygon shape is too huge for QuickDraw
#define kXMPErrInvalidCloneKind           126

#endif // _ERRORDEF_
