/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    DrgDrpSU.h

  Contains:  Class definition for XMPDragDropStorageUnit

  Written by:  Paul Hartenstine

*/

#ifndef _DRGDPSUM_
#define _DRGDPSUM_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _REFCTOBJ_
#include "RefCtObj.h"
#endif

#ifndef _STORAGEU_
#include "StorageU.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
  The DragDropStorageUnit is used only by the Drag and Drop object and only
  for presenting non-OpenDoc data dragged into an OpenDoc document.  All 
  values in a DrapDropStorageUnit act as promises but instead of calling the
  source part to resolve the promise the DragDropStorageUnit knows to call the
  Drag and Drop object to fulfill the promise.  This allows the Drag and Drop
  object to defer reading data from the Drag Manager until the data is 
  actually requested.  This allows us to work around a problem with the 
  Drag Manager that doesn't allow data to be read at drag tracking time and
  also cuts down on the amount of time spent reading in data that might not
  be used.  --pjh
*/

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================

class XMPDragDropStorageUnit;

//==============================================================================
// Classes used by this interface
//==============================================================================

class XMPStorageUnit;
class XMPDragAndDrop;

//==============================================================================
// XMPDragDropStorageUnit
//==============================================================================

#define kXMPDragDropStorageUnitID "appl:xmpdragdropstorageunit$class,1.0.0"

class XMPDragDropStorageUnit : public XMPStorageUnit
{
  
  public:

  XMPDragDropStorageUnit();
  XMPVMethod ~XMPDragDropStorageUnit();
  
  XMPNVMethod void InitStorageUnit(XMPDraft* draft, XMPStorageUnitID suid);
  
  //-------------------------------------
  // For drag and drop object information

  XMPMethod void SetDragAndDropCallback(XMPDragAndDrop* theDragAndDrop);
  XMPMethod XMPDragAndDrop* GetDragAndDropCallback();

  XMPMethod void SetIsForeignData(XMPBoolean isForeignData);
  XMPMethod XMPBoolean GetIsForeignData();

  //------------------------------------
  // For drag and drop promise operation
  
    // OVERRIDE

  XMPMethod void ResolvePromise();
  
  XMPMethod CMContainer GetCMContainer();

  private:
  
    XMPBoolean    fIsForeignData;
  XMPDragAndDrop*  fDragAndDrop;
};

#endif // _DRGDPSUM_
