
/********************************************************************/
/*  Licensed Materials - Property of IBM                            */
/*                                                                  */
/*                                                                  */
/* Copyright (C) International Business Machines Corp., 1994.       */
/* Copyright (C) Apple Computer, Inc., 1994                         */
/*                                                                  */
/*  US Government Users Restricted Rights -                         */
/*  Use, duplication, or disclosure restricted                      */
/*  by GSA ADP Schedule Contract with IBM Corp.                     */
/*                                                                  */
/********************************************************************/
/*
  File:    DragDrop.h

  Contains:  Class definition for Drag and Drop.

  Written by:  Paul Hartenstine

*/

#ifndef _DRAGDRPM_
#define _DRAGDRPM_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _DRAGDROP_
#include "DragDrop.h"
#endif

#ifndef _DRGDPSUM_
#include "DrgDpSUM.h"
#endif

#ifndef __DRAG__
#include <Drag.h>
#endif

#ifdef PLATFORM_OS2
typedef unsigned long FlavorType;
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPMacDragAndDrop;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPSession;
class XMPPart;
class XMPStorageUnit;
class XMPFacet;
class XMPFrame;
class XMPStorageSystem;
class XMPWindow;
class XMPWindowState;
class XMPDragItemIterator;
class LinkedList;

struct XMPPoint;

//=====================================================================================
// Constants
//=====================================================================================
#define kXMPDragFlavor           0x50415254  // 'PART'

#define kXMPdragHasLeftSourceFrame    0x00000001
#define kXMPdragIsInSourcePart      0x00000002
#define kXMPdragIsInSourceFrame      0x00000004

//=====================================================================================
// XMPMacDragAndDrop
//=====================================================================================

#define kXMPMacDragAndDropID "appl:xmpmacdraganddrop$class,1.0.0"

class XMPMacDragAndDrop : public XMPAbsDragAndDrop
{
public:
  
  XMPMacDragAndDrop(XMPSession* session);
    
  XMPVMethod ~XMPMacDragAndDrop();
    
  XMPNVMethod void  InitDragAndDrop();
  
  XMPMethod  XMPSize  Purge(XMPSize size);

  XMPMethod void Clear();
    
  XMPMethod XMPStorageUnit* GetStorageUnit();
    
  XMPMethod XMPDropResult StartDrag(XMPFrame* srcFrame,
                     XMPValueType imageType,
                     XMPPtr image,
                     XMPPart** destPart,
                     XMPPtr refCon);
  
  // Macintosh specific methods
    
  XMPMethod XMPULong GetDragAttributes();
    
  XMPMethod DragReference GetDragReference();

private:

  #ifdef __OS2__
     public:
     void MyDragTrackingHandler( XMPEventData evt );
     private:
  #else
     static OSErr pascal MyDragTrackingHandler(short message, WindowPtr theWindow,
                               void *handlerRefCon, DragReference theDrag);
  #endif

  #ifdef __OS2__
     public:
     pascal OSErr MyReceiveDropHandler( XMPEventData evt );
     private:
  #else
  static OSErr pascal MyReceiveDropHandler(WindowPtr theWindow, void *handlerRefCon,
                                             DragReference theDrag);
  #endif

#ifndef PLATFORM_OS2
  static OSErr pascal MySendDataProc(FlavorType theType, void *refCon,                                                                                                                                                                                         
                                     ItemReference theItem, DragReference theDrag);                                                                                                                                                                            
#endif

  XMPFacet* FindTargetFacet(XMPPlatformWindow theWindow, XMPPoint mouse, XMPPoint* local);

  static OSErr pascal PromiseAEHandler(AppleEvent* message, AppleEvent* reply, long refCon);

  XMPSession*       fSession;
  XMPWindowState*     fWindowState;
  XMPStorageSystem*   fStorageSystem;

  LinkedList      *fDragItemList;
  XMPBoolean       fListFromHandler;
  XMPDragItemIterator *fDragItemIterator;

  XMPULong       fAttributes;
  DragReference     fDragReference;
                    
  XMPFacet*       fPrevFacet;
  XMPFrame*       fSourceFrame;
  XMPPart*       fSourcePart;
  XMPFacet*       fDestFacet;
  
  XMPBoolean           fNeverDrop;   //dwf
  
  #ifdef NOT_YET
     AEEventHandlerUPP  fPromiseAEHandler;                                                                                                                                                                                                                        
  #endif

public:  // Private by convention

  void GetPromiseFromDragManager(XMPPart *sourcePart, XMPStorageUnitView *destSUView);
  void GetDataFromDragManager(XMPStorageUnitView *theSUView);
};

#endif // _DRAGDRPM_