/********************************************************************/
/*  Licensed Materials - Property of IBM                            */
/*                                                                  */
/*                                                                  */
/* Copyright (C) International Business Machines Corp., 1994.       */
/* Copyright (C) Apple Computer, Inc., 1994                         */
/*                                                                  */
/*  US Government Users Restricted Rights -                         */
/*  Use, duplication, or disclosure restricted                      */
/*  by GSA ADP Schedule Contract with IBM Corp.                     */
/*                                                                  */
/********************************************************************/
/*
  File:    DragDrop.h

  Contains:  Class definition for Drag and Drop.

  Written by:  Vincent Lo

*/

#ifndef _DRAGDROP_
#define _DRAGDROP_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPAbsDragAndDrop;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPPart;
class XMPFrame;
class XMPSession;
class XMPStorageUnit;

//=====================================================================================
// XMPAbsDragAndDrop
//=====================================================================================

class XMPAbsDragAndDrop : public XMPObject
{
public:
  
  XMPAbsDragAndDrop(XMPSession* session) {XMPUnused(session);}
    
  XMPVMethod ~XMPAbsDragAndDrop() {}
    
  XMPVMethod void InitDragAndDrop()
    = 0;

  XMPVMethod XMPSize Purge(XMPSize size)
    = 0;
  
  XMPVMethod void Clear()
    = 0;
    
  XMPVMethod XMPStorageUnit* GetStorageUnit()
    = 0;
    
  XMPVMethod XMPDropResult StartDrag(XMPFrame* srcFrame,
                     XMPValueType imageType,
                     XMPPtr image,
                     XMPPart** destPart,
                     XMPPtr refCon)
    = 0;
};

//#ifdef PLATFORM_MACINTOSH
//#ifndef _DRAGDRPM_
#include "DragDrpM.h"
//#endif
//#endif

#endif // _DRAGDROP_ 