/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    Document.h

  Contains:  Definition for XMPDocument

  Written by:  Vincent Lo, Tantek I. Celik

*/

#ifndef _DOCUMENT_
#define _DOCUMENT_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _REFCTOBJ_
#include "RefCtObj.h"
#endif

#ifndef _DRAFT_
#include "Draft.h"
#endif

//==============================================================================
// Constants
//==============================================================================
const  XMPDraftID  kXMPDefaultDraft =  1;

//==============================================================================
// Scalar Types
//==============================================================================
typedef  XMPID    XMPDocumentID;
typedef  XMPISOStr  XMPDocumentName;

//==============================================================================
// Classes defined in this interface
//==============================================================================
class  XMPDocument;

//==============================================================================
// Classes used by this interface
//==============================================================================
class  XMPContainer;
class  XMPBentoContainer;
class  DraftList;
class  VersionList;
class  XMPDocStorageUnit;

//==============================================================================
// XMPDocument
//==============================================================================

#define kXMPDocumentID "appl:xmpdocument$class,1.0.0"

class XMPDocument : public XMPRefCntObject {

public:

  XMPMethod  XMPContainer* GetContainer();

  XMPMethod  XMPDocumentID GetID();
      
  XMPMethod  XMPDocumentName GetName();
      
  XMPMethod  void SetName(XMPDocumentName name);
  
  XMPMethod  XMPStorageUnit*  GetDocumentProperties();

  XMPMethod  void IncrementRefCount();
  
  XMPMethod  void Release();

  XMPMethod  XMPDocument* CollapseDrafts(XMPDraft* from,XMPDraft* to);

  XMPMethod  XMPDraft* GetDraft(XMPDraftPermissions perms,
                XMPDraftID id,
                XMPDraft* draft,
                XMPPositionCode posCode,
                XMPBoolean release);
      
  XMPMethod  XMPDraft* GetBaseDraft(XMPDraftPermissions perms);  
  
  XMPMethod  XMPDraft* CreateDraft(XMPDraft* below,XMPBoolean releaseBelow);
      
  XMPMethod  void SaveToAPrevDraft(XMPDraft* from,XMPDraft* to);

  XMPMethod  void SetBaseDraftFromForeignDraft(XMPDraft* draft);

private:

  XMPMethod CMValue GetCMVersionList();
  
  XMPMethod XMPDraft*  GetDraftGut(VersionList* versionList,
                XMPDraftPermissions perms,
                XMPDraftID id,
                XMPDraft* draft,
                XMPPositionCode posCode,
                XMPBoolean release);
    
  XMPDocStorageUnit*    fDocumentProperties;
  XMPBentoContainer*    fContainer;
  XMPDocumentID       fID;
  DraftList*        fDrafts;
  DraftList*        fReleasedDrafts;
  VersionList*      fVersions;
  XMPULong        fVersionListSemaphore;
  XMPHeap          fHeap;
  
public:  // private by convention

  XMPDocument();
    
  XMPVMethod  ~XMPDocument();
      
  XMPNVMethod void InitDocument(XMPContainer* container, XMPDocumentID id);

  XMPMethod XMPDocument* ReleaseDraft(XMPDraft* draft);

  XMPMethod XMPSize Purge(XMPSize size);
  
  XMPMethod void InternalizeVersionList();
  
  XMPMethod void ExternalizeVersionList();

  XMPMethod void      Reopen();
  XMPMethod VersionList*  GetVersionList();
  XMPMethod VersionList*  TestAndGetVersionList();
  XMPMethod void      ReleaseVersionList();
  XMPMethod XMPHeap    GetHeap();
  XMPMethod void      ReleaseStorageUnit(XMPStorageUnit* su);
};

#endif  // _DOCUMENT_
