/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    StorageU.h

  Contains:  definition of XMPStorageUnit

  Written by: Vincent Lo

*/

#ifndef _DOCSU_
#define _DOCSU_

#ifndef _STORAGEU_
#include "StorageU.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

//==============================================================================
// Classes defined in this interface
//==============================================================================

class  XMPDocumentStorageUnit;

//==============================================================================
// Classes used by this interface
//==============================================================================

class  XMPDocument;
class  XMPDraft;
class  XMPPart;
class  XMPStorageUnitCursor;
class  XMPStorageUnitView;
class  XMPAEHashTable;

class  XMPRefTable;
class  XMPRefCollection;

//==============================================================================
// XMPStorageUnit
//==============================================================================

#define kXMPDocStorageUnitID "appl:xmpdocstorageunit$class,1.0.0"

class XMPDocStorageUnit : public XMPStorageUnit {

public:

  //-------------------------------------------------------------------------
  // From ObjectStorage protocol
  //-------------------------------------------------------------------------
  
  XMPMethod  XMPDraft*  GetDraft();
  
  XMPMethod  void IncrementRefCount();
  
    // OVERRIDE
    // See base class.
    
  XMPMethod  void Release();

    // OVERRIDE
    // See base class.

  XMPMethod XMPSize Purge(XMPSize size);
  
    // OVERRIDE
    // See base class.
  
  XMPMethod  XMPStorageUnit*  Externalize();  
  
    // Makes all changes persistent
    
  XMPMethod   XMPStorageUnit*  Internalize();  
  
    // Set state from persistent store, drop current state
    
  XMPMethod void      CopyTo(XMPStorageUnit* toSU);
  
    // Shallow copy this storage unit to toSU.
    
  XMPMethod XMPStorageUnit*  CloneTo(XMPDraftKey key, XMPDraft* destDraft, XMPStorageUnit* initiatingFrame);
  
    // Deep copy the fromSU to this storage unit.

  XMPMethod void      CloneInto(XMPDraftKey key, XMPStorageUnit* toSU, XMPStorageUnit* initiatingFrame);
  
    // Deep copy the fromSU to this storage unit.
  
  //----------------------------------------------
  // Embedded Storage Unit Ref getting & resolving
  
  XMPMethod XMPStorageUnitRef  GetStrongStorageUnitRef(XMPStorageUnit* embeddedSU);
  XMPMethod XMPStorageUnitRef  GetWeakStorageUnitRef(XMPStorageUnit* embeddedSU);
  XMPMethod XMPBoolean    IsStrongStorageUnitRef(XMPStorageUnitRef ref);
  XMPMethod XMPBoolean    IsWeakStorageUnitRef(XMPStorageUnitRef ref);
  XMPMethod XMPStorageUnit*  RemoveStorageUnitRef(XMPStorageUnitRef aRef);
  XMPMethod XMPStorageUnitID  GetIDFromStorageUnitRef(XMPStorageUnitRef aRef);
  
  XMPMethod XMPStorageUnitRefIterator* GetStorageUnitRefIterator();

  //---------
  // Promises

  XMPMethod  XMPBoolean  IsPromiseValue();
  XMPMethod  void    SetPromiseValue(XMPValueType valueType,
                      XMPULong offset,
                      XMPULong length,
                      XMPValue value,
                      XMPPart *sourcePart);
  XMPMethod  XMPULong  GetPromiseValue(XMPValueType valueType,
                      XMPULong offset,
                      XMPULong length,
                      XMPValue value,
                      XMPPart **sourcePart);
  XMPMethod  void    ClearAllPromises();

  XMPMethod   XMPStorageUnitKey  Lock(XMPStorageUnitKey key);
  XMPMethod  void        Unlock(XMPStorageUnitKey key);
  

private:
  
  XMPDocument*    fDocument;  

public: // Private by convention calls:

  XMPDocStorageUnit();
  
    // Instantiate an object which represents a storage unit with
    //  given id in a Draft.
    // This only creates the XMPStorageUnit without internalizing the
    //  storage unit.

  XMPVMethod  ~XMPDocStorageUnit();

  XMPNVMethod  void InitStorageUnit(XMPDocument* document, XMPStorageUnitID id);

  XMPMethod  void    ResolvePromise();
  XMPMethod  void    ResolveAllPromises();
  XMPMethod  XMPPtr    GetPromiseInfo();
  XMPMethod  void    SetPromiseInfo(XMPPtr theInfo);
  XMPMethod  void    IncrementPromiseCount();
  XMPMethod  void    DecrementPromiseCount();
  
  XMPMethod  CMContainer GetCMContainer();
  XMPMethod  void    SetChangedFromPrevFlag(XMPBoolean changed);

  XMPMethod  XMPHeap    GetHeap();
};


#endif  // _DOCSU_
