/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    DocPriv.h

  Contains:  Private Definition for XMPDocument

  Written by:  Vincent Lo

*/


#ifndef _DOCPRIV_
#define _DOCPRIV_

#ifndef _LIST_
#include "List.h"
#endif

#ifndef _DRAFT_
#include "Draft.h"
#endif

//==============================================================================
// Constants
//==============================================================================
const  XMPVersionID  kXMPTombstonedVersion = 0;

//==============================================================================
// Classes defined in this interface
//==============================================================================
class DraftLink;
class DraftList;
class VersionList;
class DraftListIterator;
class VersionListIterator;

//==============================================================================
// Classes used by this interface
//==============================================================================

//==============================================================================
// DraftLink
//==============================================================================

class DraftLink : public Link {

public:
  
  DraftLink(XMPDraftID id, XMPDraft* draft)
  {
    fDraftID = id;
    fDraft = draft;
  }
  ~DraftLink() {;};
  
  XMPDraftID GetDraftID() {return fDraftID;};
  XMPDraft*  GetDraft() {return fDraft;};

private:
  
  XMPDraftID        fDraftID;
  XMPDraft*        fDraft;
};

//==============================================================================
// DraftList
//==============================================================================

class DraftList
{  
public:

  DraftList();
  
  XMPVMethod  ~DraftList();
  
  XMPMethod void Initialize();
  
  XMPMethod void Add(XMPDraftID draftID, XMPDraft* draft);
  
  XMPMethod void Remove(XMPDraftID draftID);
  
  XMPMethod XMPDraft* Get(XMPDraftID draftID);
  
private:

  XMPMethod DraftLink* GetLink(XMPDraftID draftID);
  

  LinkedList* fLinkedList;
  
  XMPHeap    fHeap;
  
public:  // private by convention

  XMPMethod  XMPHeap    GetHeap();
  XMPMethod  LinkedList* GetLinkedList();
};

//==============================================================================
// DraftListIterator
//==============================================================================

class DraftListIterator
{

public:

  DraftListIterator(DraftList* DraftList);
  
  ~DraftListIterator();
  
  XMPMethod  void    Initialize();
  
  XMPMethod  XMPDraft*  Last();
  XMPMethod  XMPDraft*  Previous();
  XMPMethod  XMPBoolean  IsNotComplete();
  
private:

  DraftList*      fDraftList;
  LinkedListIterator* fIterator;
};

//==============================================================================
// VersionLink
//==============================================================================

class VersionLink : public Link {

public:
  
  VersionLink(XMPDraftID draftID, XMPVersionID versionID);
  ~VersionLink() {;};
  
  XMPDraftID    GetDraftID() {return fDraftID;};
  XMPVersionID  GetVersionID() {return fVersionID;};
  void      SetVersionID(XMPVersionID versionID) {fVersionID = versionID;};

private:

  XMPDraftID        fDraftID;
  XMPVersionID      fVersionID;
};

  
//==============================================================================
// VersionList
//==============================================================================

class VersionList {
  
public:

  VersionList();
  XMPVMethod  ~VersionList();
  
  XMPMethod  void Initialize();
  XMPMethod  void Initialize(XMPPtr buffer, XMPULong size);
  XMPMethod  void ExportTo(XMPPtr* buffer, XMPULong* size);
  XMPMethod  void Reinitialize(XMPPtr buffer, XMPULong size);
  
  XMPMethod   XMPDraftID CreateDraft();
  XMPMethod  void RemoveDraft(XMPDraftID draftID);
  
  XMPMethod  XMPVersionID  GetDraft(XMPDraftID draftID);
  
  XMPMethod  XMPVersionID  CreateVersion(XMPDraftID draftID);
  XMPMethod  XMPVersionID  GetCurrentVersion(XMPDraftID draftID);
  
  XMPMethod  XMPBoolean Exists(XMPDraftID draftID);
  
  XMPMethod  void       CollapseDrafts(XMPDraftID fromDraftID, XMPDraftID toDraftID);
  XMPMethod  void       SaveToAPrevDraft(XMPDraftID fromDraftID, XMPDraftID toDraftID);
  XMPMethod  XMPVersionID  RemoveChanges(XMPDraftID draftID);
  XMPMethod  XMPBoolean    ChangedFromPrev(XMPDraftID draftID);

  XMPMethod  XMPDraftID GetBaseDraftID();
  XMPMethod  XMPDraftID GetLatestDraftID();
  XMPMethod  XMPDraftID GetPreviousDraftID(XMPDraftID draftID);
  XMPMethod  XMPDraftID GetNextDraftID(XMPDraftID draftID);
  
  XMPMethod  XMPBoolean  IsAbove(XMPDraftID draftID1, XMPDraftID draftID2);
  XMPMethod  XMPBoolean  IsBelow(XMPDraftID draftID1, XMPDraftID draftID2);
    
private:

  XMPMethod  VersionLink* GetLink(XMPDraftID draftID);
  XMPMethod  void Clear();
  
  LinkedList*    fLinkedList;
  XMPHeap      fHeap;
  XMPVersionID  fLatestVersionID;
  
public: // private by convention

  XMPMethod  XMPHeap    GetHeap();
  XMPMethod  LinkedList*  GetLinkedList();
};


//==============================================================================
// VersionListIterator
//==============================================================================

class VersionListIterator
{

public:

  VersionListIterator(VersionList* versionList);
  
  XMPVMethod  ~VersionListIterator();
  
  XMPMethod  void  Initialize();
  
  XMPMethod  VersionLink*  Last();
  XMPMethod  VersionLink*  Previous();
  XMPMethod  XMPBoolean    IsNotComplete();
  
private:

  VersionList*    fVersionList;
  LinkedListIterator* fIterator;
};

#endif  // _DOCPRIV_
