/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    XMPDispatcher.h

   Contains:   Interface to XMPMacDispatcher class.

   Written by: Richard Rodseth

*/

#ifndef _DISPATCHM_
#define _DISPATCHM_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _ORDCOLL_
#include "OrdColl.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPMacDispatcher;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPFacet;
class XMPFrame;
class XMPPart;
class XMPSession;
class TimerList;
class TimerWindow;
class DispatchTable;

//=====================================================================================
// XMPMacDispatcher
//=====================================================================================

#define kXMPMacDispatcherID "appl:xmpmacdispatcher$class,1.0.0"

class XMPMacDispatcher : public XMPAbsDispatcher
{
public:
   
   XMPMacDispatcher();
   
   XMPVMethod ~XMPMacDispatcher();
   
   XMPNVMethod void InitDispatcher(XMPSession* session); 
   
   XMPMethod   XMPSize  Purge(XMPSize size); 
   
#ifdef USE_EVENT_TYPES
   XMPMethod void AddDispatchModule(XMPEventType eventType, 
                              XMPDispatchModule* dispatchModule);

   XMPMethod void RemoveDispatchModule(XMPEventType eventType);

   XMPMethod void AddMonitor(XMPEventType eventType,XMPDispatchModule* dispatchModule);
   
   XMPVMethod void RemoveMonitor(XMPEventType eventType, XMPDispatchModule* dispatchModule);
#else
   XMPMethod void AddDispatchModule(XMPDispatchModule* dispatchModule,
                                    XMPBoolean addToFront);

   XMPMethod void RemoveDispatchModule(XMPDispatchModule* dispatchModule);

   XMPMethod void AddMonitor(XMPDispatchModule* dispatchModule);
   
   XMPVMethod void RemoveMonitor(XMPDispatchModule* dispatchModule);
#endif
   
   XMPMethod XMPBoolean Dispatch(XMPEventData event);
   
   XMPMethod   void TerminateEventLoop();
   
   XMPMethod XMPBoolean ShouldTerminateEventLoop();
   
protected:

   XMPSession* fSession;   // Access to globals
   
private:

   XMPBoolean  fTerminateEventLoop; // This is set to TRUE when the dispatcher thinks
                            // the shell application ought to Quit.

#ifdef USE_EVENT_TYPES
   DispatchTable* fDispatchTable;
#else
   OrderedCollection* fDispatchModules;                                                                                                                                                                                                                        
   OrderedCollection* fMonitors;                                                                                                                                                                                                                               
#endif
};

#endif // _DISPATCHM_   
