/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    Disptch.h

   Contains:   Interface to XMPAbsDispatcher class.

   Written by: Richard Rodseth

*/

#ifndef _DISPTCH_
#define _DISPTCH_

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class XMPDispatcher;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPDispatchModule;
class XMPFacet;
class XMPFrame;
class XMPPart;
class XMPSession;

//=====================================================================================
// XMPAbsDispatcher
//=====================================================================================

class XMPAbsDispatcher : public XMPObject
{
public:
   
   XMPAbsDispatcher() {}
   
   XMPVMethod ~XMPAbsDispatcher() {}
   
   XMPVMethod  XMPSize  Purge(XMPSize size)     
      = 0; 

#ifdef USE_EVENT_TYPES
   XMPVMethod void AddDispatchModule(XMPEventType eventType, 
                              XMPDispatchModule* dispatchModule)
      = 0; 
   
   XMPVMethod void RemoveDispatchModule(XMPEventType eventType)
      = 0; 
   
   XMPMethod void AddMonitor(XMPEventType eventType,XMPDispatchModule* dispatchModule)
      = 0;
   
   XMPVMethod void RemoveMonitor(XMPEventType eventType, XMPDispatchModule* dispatchModule)
      = 0; 
#else
   XMPVMethod void AddDispatchModule(XMPDispatchModule* dispatchModule,
                                     XMPBoolean addToFront)
      = 0; 
   
   XMPVMethod void RemoveDispatchModule(XMPDispatchModule *dispatchModule)
      = 0; 
   
   XMPMethod void AddMonitor(XMPDispatchModule* dispatchModule)
      = 0;
   
   XMPVMethod void RemoveMonitor(XMPDispatchModule* dispatchModule)
      = 0; 
#endif
   
   XMPVMethod XMPBoolean Dispatch(XMPEventData eventData)
      = 0; 
   
   XMPVMethod  void TerminateEventLoop()
      = 0; 
   
   XMPVMethod XMPBoolean ShouldTerminateEventLoop()
      = 0; 
};

#ifdef PLATFORM_MACINTOSH
#ifndef _DISPATCHM_
#include "DisptchM.h"
#endif
#endif

#endif // _DISPTCH_
