/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    DictList.h

  Contains:  Definition of class DictionaryList

  Written by:  Richard Rodseth

*/

#ifndef _DICTLIST_
#define _DICTLIST_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _LIST_
#include "List.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

// OrdereCollection is an ordered collection of elements of type void* (since
// we can't use templates)
// Duplicates are allowed.

//==============================================================================
// Constants
//==============================================================================

//==============================================================================
// Scalar Types
//==============================================================================

typedef void* KeyType;
typedef void* ValueType;

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class DictionaryList;  

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class Association; // Defined in implementation

//=====================================================================================
// Global Variables
//=====================================================================================


//=====================================================================================
// Class DictionaryList
//=====================================================================================

#define kDictionaryListID "appl:dictionarylist$class,1.0.0"

class DictionaryList
{
public:

  DictionaryList();
  virtual ~DictionaryList();

  XMPVMethod void  AddPair(KeyType key, ValueType value);
  
  XMPVMethod XMPULong Count();
  XMPVMethod XMPBoolean ContainsKey(KeyType key);
  XMPVMethod ValueType ValueAtKey(KeyType key);

  XMPVMethod void  RemoveKey(KeyType key);
  XMPVMethod void  RemoveAll();      
  XMPVMethod void  DeleteKeys();
  XMPVMethod void  DeleteValues();
  
protected:

   XMPVMethod Association* CreateNewAssociation(KeyType key, ValueType value) const;
   XMPVMethod XMPBoolean  KeysMatch(KeyType key1,KeyType key2) const;
   
     // Does a straight == comparison by default 

private:

  LinkedList    fImplementation;
};

#endif // _DICTLIST_
