/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    CmdTable.h

   Contains:   Interface to CommandTable class

   Written by: Richard Rodseth

*/

#ifndef _CMDTABLE_
#define _CMDTABLE_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _LIST_
#include "List.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   This class stores a mapping from menu/item to command number.
   It's currently implemented using a linked list of triples, 
   which may not be sufficiently sophisticated.
*/

//==============================================================================
// Scalar Types
//==============================================================================

//==============================================================================
// Constants
//==============================================================================

const XMPCommandID kNoCommand = 0;

//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class CommandTable;  

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class LinkedList;

//=====================================================================================
// Global Variables
//=====================================================================================

//=====================================================================================
// Class CommandTable
//=====================================================================================

class CommandTable
{
public:

   CommandTable();
   XMPVMethod ~CommandTable();
   
   XMPVMethod CommandTable* Copy();

   XMPVMethod void   RegisterCommand(XMPCommandID command,
                           XMPMenuID menu,
                           XMPMenuItemID menuItem);
   
   XMPVMethod XMPBoolean IsCommandRegistered(XMPCommandID command);
   
   XMPVMethod XMPCommandID GetCommand(XMPMenuID menu,
                           XMPMenuItemID menuItem);
   XMPVMethod XMPBoolean GetMenuAndItem(XMPCommandID command,
                           XMPMenuID& menu,
                           XMPMenuItemID& menuItem);

   XMPVMethod void UnregisterCommand(XMPCommandID command);
   XMPVMethod void   UnregisterAll();        
   
private:

   LinkedList     fImplementation;
};

#endif // _CMDTABLE_
