/*
  File:    ClkDef.h

  Contains:  Common put contents here ClkPart

  Written by:  Lonnie Millett

  Copyright:   1994 by Apple Computer, Inc., all rights reserved.

  Change History (most recent first):

    <2+>   1/25/94  MB    Update NMAP resources to the
                  Internationalizable format.
    <1+>   1/14/94  MB    Making part binding changes
    <1+>   1/13/94  MB    ASLM support

  To Do:
*/

#ifndef _CLKDEF_
#define _CLKDEF_

// Kind
#define kSampleClockKind "Apple:Kind:Framework:Sample:Clock"

// Class ID
#define kClkPartID "appl:framework:sample:clockpart$class,1.0.0"

// Editor User String
#define kSampleClockEditorUserString "Sample Clock 1.0"

// Kind User String
#define kSampleClockKindUserString "Sample Clock"

// Category User String
#define kSampleClockCategoryUserString "Time"

// Clock OSType
#define kSampleClockOSType 'CLCK'

#ifdef ASLMBUILD
#define FW_kKindCategoryMapId    kNMAPid+1
#define FW_kEditorKindMapId      kNMAPid+2
#define FW_kEditorUserStringMapId  kNMAPid+3
#define FW_kKindUserStringMapId    kNMAPid+4
#define FW_kCategoryUserStringMapId  kNMAPid+5
#define FW_kOldMacOSTypeMapId    kNMAPid+6
#else
// For the static build, the value of FW_kKindCategoryMap must pick up where the last part
// left off. kNMAPid+31 is the last value used by the button part.
#define FW_kKindCategoryMapId    kNMAPid+32
#define FW_kEditorKindMapId      kNMAPid+33
#define FW_kEditorUserStringMapId  kNMAPid+34
#define FW_kKindUserStringMapId    kNMAPid+35
#define FW_kCategoryUserStringMapId  kNMAPid+36
#define FW_kOldMacOSTypeMapId      kNMAPid+37
// Our draw part picks up with kNMAPid+38, see QDrawDef.h
#endif

// Menus
#define kClockTypeMenu 5
#define kClockSoundsMenu 6

// Strings
#define kClockPartStrings 1000
#define kClockAnalogMenuString 1
#define kClockDigitalMenuString 2
#define kClockDigitalWidthString 3
#define kClockFaceString 4

// Sounds
#define kClockChime 1000
#define kClockTick 1001

// Kind
#define kXMPKindTestClock "Apple:Kind:TestClock"

// Class ID
#define kClockPartID "appl:clockpart$class,1.0.0"

//-------------------------------------------------------------------------
// Constants
//-------------------------------------------------------------------------

#define MATLF_SIZE ( sizeof ( MATRIXLF ) / sizeof ( LONG ) )

#define CLK_MAJORTICKS  0x0001
#define CLK_MINORTICKS  0x0002

#define XDATE 52L
#define YDATE 14L
#define ZDATE 1L

#define HT_HOUR           1
#define HT_MINUTE         2
#define HT_HOUR_SHADE     3
#define HT_MINUTE_SHADE   4
#define HT_SECOND   5

#define DM_TIME         ( (USHORT)0x0001)
#define DM_DATE         ( (USHORT)0x0002)
#define DM_ANALOG       ( (USHORT)0x0010)
#define DM_DIGITAL      ( (USHORT)0x0020)
#define DM_SECONDHAND   ( (USHORT)0x0040)

#define MAXTITLELENGTH 256
#ifndef  MESSAGELEN
#define MESSAGELEN     80
#endif
#define SHADE               0
#define LIGHT               1
#define SURFACE             2
#define BACKGROUND          3

#define DP_INSIDE           0
#define DP_UNDER            1
#define DP_LEFTDOWN         2
#define DP_LEFTMIDDLE       3

#define DM_REDRAW           0
#define DM_UPDATE           1

#define AM_ACTIVE           ( (USHORT) 0x0001)
#define AM_AUDIO            ( (USHORT) 0x0002)
#define AM_MSGBOX           ( (USHORT) 0x0004)
#define TIMER_ASYNC         1
#define TIMER_CONT          2
#define SEM_TIMER_NAME      "\\sem32\\applnam.sem"
#ifndef NO_ERROR
#define NO_ERROR            (APIRET ) 0L
#endif

#define SEM_TIMER_VALUE     ( (ULONG) (1000L * 60 * 60) )

#define SZ_APPNAME  "ClockProgram 2.1"
#define SZ_KEYNAME  "Preferences"

/*--------------------------------------------------------------*\
 *  Messagetable ids
\*--------------------------------------------------------------*/
#ifndef IDMSG_INITFAILED

#define IDMSG_INITFAILED              101
#define IDMSG_MAINWINCREATEFAILED     102
#define IDMSG_CANNOTOPENINPUTFILE     103
#define IDMSG_CANNOTOPENOUTPUTFILE    104
#define IDMSG_CANNOTRUNCOLOR          108
#define IDMSG_CANNOTGETHPS            109
#define IDMSG_HELPLOADERROR           110
#define IDMSG_CANNOTLOADSTRING        111
#define IDMSG_CANNOTOPENPRINTER       112
#define IDMSG_HELPDISPLAYERROR        113
#define IDMSG_CANNOTLOADEXITLIST      114
#define IDMSG_PRINTINITFAILED         115
#define IDMSG_OVERWRITEFILE           116
#define IDMSG_PRINTERROR              117
#define IDMSG_UNDOFAILED              118
#define IDMSG_CANNOTGETFILEINFO       119
#define IDMSG_CANNOTALLOCATEMEMORY    120
#define IDMSG_CANNOTREADFILE          121
#define IDMSG_CANNOTWRITETOFILE       122
#define IDMSG_CANNOTLOADFONTS         123
#define IDMSG_CANNOTGETPAGEINFO       124
#endif
/**************************************************************************\
*                                                                          *
*       MODULE:     dialogs.h                                              *
*                                                                          *
*       COMMENT:    Constants for the Clock dialogs                        *
*                                                                          *
\**************************************************************************/


#define CLKTM_MAJOR 0x0100
#define CLKTM_MINOR 0x0200

#define CLKTM_ALWAYS    0x0001
#define CLKTM_NOTICONIC 0x0002
#define CLKTM_NEVER     0x0004

#define CLKCLR_BUTTONSHIFT 0x08

#define CLKCLR_OBJECTS      0x0100
#define CLKCLR_BACKGROUND   0x0101
#define CLKCLR_FACE         0x0102
#define CLKCLR_HOURHAND     0x0103
#define CLKCLR_MINUTEHAND   0x0104

#define CCHMAXSTRING                    256
#define TIME_SEP_LEN        1
#define DATE_SEP_LEN        1
#define STRING_AM_LEN       2
#define STRING_PM_LEN       2
#define AM_PM  2                    /* index into rTimeSep */
#define PATHMAX 259           /* path cb     max                     */
#define COUNTRY_USA     1              /* Country code               */
#define COUNTRY_UK      44             /* Country code               */

/*--------------------------------------------------------------*\
 *  Standard Dialog box ids
\*--------------------------------------------------------------*/
#define FILEOPEN        2000
#define FILESAVE        2001

#define MSGBOXID        1001
#define OBJECTID        1002

//-------------------------------------------------------------------------
// Structures
//-------------------------------------------------------------------------

struct CLOCKTIME
{
   UCHAR hours;
   UCHAR minutes;
   UCHAR seconds;
   UCHAR hundredths;
   CLOCKTIME()
   {
     hours      = 0;
     minutes    = 0;
     seconds    = 0;
     hundredths = 0;
   }
   CLOCKTIME( const DATETIME& dt)
   {
     hours      = dt.hours;
     minutes    = dt.minutes;
     seconds    = dt.seconds;
     hundredths = dt.hundredths;
   }
     
};

struct ALARMTIME
{
   UCHAR uchHour;
   UCHAR uchMinutes;
   USHORT usMode;
};


struct CLOCKPREF
{
    USHORT usMajorTickPref;    /*0,1*/
    USHORT usMinorTickPref;    /*2,3*/
    LONG clrBackground;        /*4,5,6,7*/
    LONG clrFace;              /*8,9,a,b*/
    LONG clrHourHand;          /*c,d,e,f*/
    LONG clrMinuteHand;        /*10,11,12,13*/
    LONG clrDateOnAnalog;      /*14,15,16,17*/
    BOOL fControlsHidden;      /*18,19*/
    USHORT usDispMode;         /*1a,1b*/
    ALARMTIME alarm ;          /*1c,1d,1e,1f*/
    SWP swp;                   /*20....*/
    SHORT sTimerType;

};
typedef CLOCKPREF *PCLOCKPREF;

struct INISAVERESTORE
{
    SWP    swp;
    USHORT yRestore;
    USHORT xRestore;
    USHORT yMinRestore;
    USHORT xMinRestore;
};
typedef DATETIME FAR *LPDT;    /* For DosGet/SetDateTime     */

struct CLKDATA {
   HDC  hdcBuffer;
   HPS  hpsBuffer;
   BOOL fBufferDirty;
   BOOL fEndThread;
   HRGN hClipRegion;
   CLOCKPREF cp;
   HWND hwndHelpInstance;
   HSWITCH hsw ;
   BOOL fStartAsIcon ;
   BOOL fHelpEnabled;
   SHORT      Selected ;
   SHORT      PreviousSelected;
   BOOL     bLeadingZero;
   BOOL     bIsIconic;
   WRECT rDateTime[6];
   WRECT rAlarmTime[3];      /* placement of time and date matters */
   WRECT rRepaintTime;
   WRECT rDateAssign[3];
   SHORT sFirstTime;
   SHORT sFirstDate;
   SHORT asLeftOf[6];
   SHORT asRightOf[6];
   SHORT wDateTime[6];
   SHORT wPrevDateTime[6];
   HWND  hDate,hTime;
   HWND  hDateScroll;
   HWND  hTimeScroll;
   HWND  hCurrentFocus;
   HWND  hDateTime;
   HWND  hAlarmTime;
   BOOL bTwelveHourFormat;
   WRECT rTimeSep[3];
   CHAR  szTimeSep[TIME_SEP_LEN+1];
   CHAR  szAnteMeridian[STRING_AM_LEN+1];
   CHAR  szPostMeridian[STRING_PM_LEN+1];
   CHAR  szTitle   [81];
   CHAR  szErrClocks[PATHMAX+1];
   WRECT rDateSep[2];
   CHAR  szDateSep[DATE_SEP_LEN+1];
   BOOL fTimeFreez ;
   BOOL fDateFreez ;
   USHORT vusDateFormat;
   MATRIXLF vmatlfDateTrans;
   MATRIXLF vmatlfDateScale;
   DATETIME dt ;
   BOOL fIconic , fShowSecondHand ;
   char achOldTime[9];
   char achAmPm[3];
   char achOldAmPm[3];
   char achOldDate[9];
   HPS hpsWnd;
   LONG cxScreen, cyScreen;  /* screen dimensions */
   LONG vclrBG[3];
   LONG vclrFace[3];
   LONG vclrRing[3];
   LONG vclrHands[3];
   LONG vclrMajorTicks[3];
   LONG vclrMinorTicks[3];
   LONG vclrDate[4];
   USHORT vusDatePos;
   BOOL vbInAlarm;
   HWND hwndEntryField;
};

typedef CLKDATA *PCLKDATA;

#endif

