/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    Clipbd.h

  Contains:  Class definition for XMPClipboard.

  Written by:  Vincent Lo

*/

#ifndef _CLIPBD_
#define _CLIPBD_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _XMPOBJ_
#include "XMPObj.h"
#endif

//=====================================================================================
// Types defined in this interface
//=====================================================================================
typedef XMPULong XMPClipboardKey;

//=====================================================================================
// Classes defined in this interface
//=====================================================================================
class XMPAbsClipboard;

//=====================================================================================
// Classes used by this interface
//=====================================================================================
class XMPStorageUnit;
class XMPSession;
class XMPPlatformTypeSet;

//=====================================================================================
// XMPClipboard
//=====================================================================================

class XMPAbsClipboard : public XMPObject
{
public:
    
  XMPAbsClipboard() : XMPObject() {}
  
  XMPVMethod ~XMPAbsClipboard() {}
  
  XMPVMethod XMPSize Purge(XMPSize size)
    = 0;

  XMPVMethod XMPBoolean Lock(XMPULong wait, XMPClipboardKey* key)
    = 0;
                               
  XMPVMethod void Unlock(XMPClipboardKey key)
    = 0;

  XMPVMethod XMPChangeID GetChangeID()
    = 0;
                              
  XMPVMethod void Clear(XMPClipboardKey key)
    = 0;
    
  XMPVMethod XMPStorageUnit* GetContentStorageUnit(XMPClipboardKey key)
    = 0;
    
  XMPVMethod void SetPlatformClipboard(
            XMPPlatformTypeSet* typeSet,
            XMPClipboardKey key)
    = 0;

  XMPVMethod void ExportClipboard(XMPClipboardKey key)
    = 0;
};

#ifdef PLATFORM_MACINTOSH
#ifndef _CLIPBDM_
#include "ClipbdM.h"
#endif
#endif

#endif // _CLIPBD_