/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
  File:    XMPBentoHandlers.h

  Contains:  Header for XMPBentoHandlers

  Written by:  Vincent Lo

*/

#ifndef _BENTOHDR_
#define _BENTOHDR_

#ifndef _PLFMDEF_
#include "PlfmDef.h"
#endif

#ifndef __CM_API__
#include "CMAPI.h"
#endif

//==============================================================================
// Classes defined in this interface
//==============================================================================
class XMPBentoHandlers;

//==============================================================================
// containerMetahandler
//==============================================================================

CM_CFUNCTIONS

CMHandlerAddr CM_FIXEDARGS containerMetahandler(CMType targetType,
                        CMconst_CMGlobalName operationType);

CM_END_CFUNCTIONS

//==============================================================================
// XMPFSContainer
//==============================================================================

class XMPBentoHandlers
{
public:
  
  XMPBentoHandlers();
  XMPVMethod ~XMPBentoHandlers();
  
  XMPMethod void Initialize()
    = 0;
    
  XMPMethod CMSession GetCMSession()
    = 0;
  
  XMPMethod CMRefCon OpenHandler(CMOpenMode mode)
    = 0;
    
  XMPMethod void CloseHandler()
    = 0;
    
  XMPMethod CMSize FlushHandler()
    = 0;
    
  XMPMethod CMSize SeekHandler(CM_LONG posOff, CMSeekMode mode)
    = 0;
    
  XMPMethod CMSize TellHandler()
    = 0;
    
  XMPMethod CMSize ReadHandler(CMPtr buffer, CMSize elementSize, CMCount theCount)
    = 0;
    
  XMPMethod CMSize WriteHandler(CMPtr buffer, CMSize elementSize, CMCount theCount)
    = 0;
    
  XMPMethod CMEofStatus EOFHandler()
    = 0;
    
  XMPMethod CMBoolean TruncHandler(CMSize containerSize)
    = 0;
    
  XMPMethod CMSize ContainerSizeHandler()
    = 0;
    
  XMPMethod void ReadLabelHandler(CMMagicBytes magicByteSequence,
            CMContainerFlags *flags, CM_USHORT *bufSize,
            CM_USHORT *majorVersion, CM_USHORT *minorVersion,
            CMSize *tocOffset, CMSize *tocSize)
    = 0;
    
  XMPMethod void WriteLabelHandler(CMMagicBytes magicByteSequence,
            CMContainerFlags flags, CM_USHORT bufSize,
            CM_USHORT majorVersion, CM_USHORT minorVersion,
            CMSize tocOffset, CMSize tocSize)
    = 0;
    
  XMPMethod CMValue ReturnParentValueHandler()
    = 0;
    
  XMPMethod CM_UCHAR* ReturnContainerNameHandler()
    = 0;
    
  XMPMethod CMType ReturnTargetTypeHandler(CMContainer container)
    = 0;
    
  XMPMethod void ExtractDataHandler(CMDataBuffer buffer,
              CMSize size, CMPrivateData data)
    = 0;
    
  XMPMethod void FormatDataHandler(CMDataBuffer buffer,
              CMSize size,
              CMPrivateData data)
    = 0;
};

#endif  // _BENTOHDR_
