/********************************************************************/ 
/*  Licensed Materials - Property of IBM                            */ 
/*                                                                  */ 
/*                                                                  */ 
/* Copyright (C) International Business Machines Corp., 1994.       */ 
/* Copyright (C) Apple Computer, Inc., 1994                         */ 
/*                                                                  */ 
/*  US Government Users Restricted Rights -                         */ 
/*  Use, duplication, or disclosure restricted                      */ 
/*  by GSA ADP Schedule Contract with IBM Corp.                     */ 
/*                                                                  */ 
/********************************************************************/ 
/*
   File:    AOCEObj.h

   Contains:   AOCEObj class interface.

   Written by: Eric House

*/

#ifndef _AOCEOBJ_
#define _AOCEOBJ_

#ifndef _XMPTYPES_
#include "XMPTypes.h"
#endif

#ifndef _MENUBAR_
#include "MenuBar.h"
#endif

//==============================================================================
// Theory of Operation
//==============================================================================

/*
   AOCEObj is a helper object for XMPMacWindow.  Its function is to isolate
   implementation of the mailer from other parts of the code.
   
*/

//=====================================================================================
// Constants
//=====================================================================================

typedef enum {
   kXMPAOCEMailerUnitialized     =  0
   ,kXMPAOCEMailerUnattached     // inited, but none added to window
   ,kXMPAOCEMailerContracted     // mailer is present, but contracted
                           // note that any state >= this one can
                           // be taken to mean it's at least
                           // attached.
   ,kXMPAOCEMailerExpanded       // there's a mailer as part of this window
} XPMAOCEMailerState ;


// used to determine how to adjust what the mailer obscures
typedef enum {
   kXMPRemoveExpanded
   ,kXMPRemoveContracted
   ,kXMPContractExpanded
   ,kXMPExpandContracted
   ,kXMPAddExpanded
   ,kXMPAddContracted
} XMPExpansionDelta ;


//=====================================================================================
// Classes defined in this interface
//=====================================================================================

class AOCEObj;

//=====================================================================================
// Classes used by this interface
//=====================================================================================

class XMPWindow ;

struct XMPPoint;

//=====================================================================================
// SystemSupportsAOCE
// This function is not part of the class because clients need to be able to
// call it *before* instantiating the class -- in case they want a NULL ptr
// to the class to mean the OCE isn't around.
//=====================================================================================

XMPBoolean SystemSupportsAOCE() ;

//=====================================================================================
// AOCEObj
//=====================================================================================

#define kAOCEObjID "appl:aoceobj$class,1.0.0"

class AOCEObj : public XMPObject
{
public:

   AOCEObj(); 

   XMPNVMethod void InitAOCEObj( XMPWindow* myWindow, XMPSession* theSession ) ;
           
      // Constructor. This window becomes a dependent window of "sourceWindow",
      // which means this window is closed if sourceWindow closes.
      // sourceWindow may be NULL.
   
   XMPVMethod ~AOCEObj();  
      // Destructor
   
   XMPMethod XMPSize Purge(XMPSize size);
   
      // See base class
      

   // AOCE Mailer stuff (Mac specific) <eeh>
   // ---------------------------------------------------------------
   
   XMPMethod   void     InitAOCE() ;
   XMPMethod   void     AddAOCEMailer( XMPBoolean done ) ;
   XMPMethod   void     RemoveAOCEMailer() ;
   XMPMethod   void     ExpandAOCEMailer() ;
   XMPMethod   void     ContractAOCEMailer(XMPBoolean alreadyContracted) ;
   XMPMethod   XMPBoolean  AOCEMailerIsPresent() ;
   XMPMethod   XMPBoolean  AOCEMailerIsExpanded() ;
   XMPMethod   void     SetAOCEMailerTargetState( XMPBoolean newState ) ;
   XMPMethod   XMPBoolean  AOCEMailerIsTarget() ;
   XMPMethod   void     DimMailerMenus( XMPMenuBar* mb ) ;

   // Public but private by convention...so far <eeh>
   XMPMethod   void     UpdateMailerMenus() ;
   XMPMethod   XMPBoolean  AOCEMailerIsReceived() ;

protected:
   XMPMethod   void     AdjustMailerSpace( XMPExpansionDelta mailerDelta ) ;

private:
   XPMAOCEMailerState   fAOCEMailerState;    // info on mailer associated with session <eeh>
   XMPBoolean        fAOCEMailerIsTarget ;   // either the mailer or the rest of window
   XMPBoolean        fAOCEInstalled ;     // <eeh> remove later

   XMPWindow*        fMyWindow ;          // the window I'm "helping"
   XMPSession*       fSession;
};

#endif // _AOCEOBJ_
