
#define _DOS
#include <iostream.h>
#include <afx.h>
#include <afxcoll.h>

class Friend_Class : public CObject
{
    Friend_Class(){};
    DECLARE_SERIAL(Friend_Class);
public:
    Friend_Class(CString First, CString Last);
    CString        FirstName;
    CString        LastName;
    void Serialize(CArchive& archive);
};

class Friend_ClassList : public CObList
{
public:
    Friend_ClassList(){};
    DECLARE_SERIAL(Friend_ClassList)
};

Friend_Class::Friend_Class(CString First, CString Last)
{
    FirstName = First;
    LastName = Last;
}

void Friend_Class::Serialize(CArchive& archive)
{
    CObject::Serialize(archive);
    if (archive.IsStoring()) archive << FirstName << LastName;
    else archive >> FirstName >> LastName;
}

IMPLEMENT_SERIAL(Friend_Class, CObject, 0)
IMPLEMENT_SERIAL(Friend_ClassList, CObList, 0)

main()
{
    CFile the_file;
    CFileException exc;
    char* pfilename = "friends.dat";
    Friend_ClassList* data_list_ptr = new Friend_ClassList;
    Friend_Class* friend_ptr_1 = new Friend_Class("Issac", "Newton");
    Friend_Class* friend_ptr_2 = new Friend_Class("Albert", "Einstein");
 
    data_list_ptr->AddHead(friend_ptr_1);
    data_list_ptr->AddHead(friend_ptr_2);

    the_file.Open(pfilename, CFile::modeCreate | CFile::modeWrite, &exc);
    CArchive the_out_Archive(&the_file, CArchive::store);
    the_out_Archive << data_list_ptr;
    the_out_Archive.Close();
    the_file.Close();

    the_file.Open(pfilename, CFile::modeRead, &exc);
    CArchive the_in_Archive(&the_file, CArchive::load);
    the_in_Archive >> data_list_ptr;
    the_in_Archive.Close();
    the_file.Close();

    POSITION pos = data_list_ptr->GetHeadPosition();
    friend_ptr_1 = (Friend_Class*)data_list_ptr->GetNext(pos);
    friend_ptr_2 = (Friend_Class*)data_list_ptr->GetNext(pos);

    cout << friend_ptr_1->FirstName << " ";
    cout << friend_ptr_1->LastName << "\n";
    cout << friend_ptr_2->FirstName << " ";
    cout << friend_ptr_2->LastName << "\n";

    return 0;
}

