#include <afxwin.h>
#include <windows.h>

class CMainWindow : public CFrameWnd
{
private:
    POINT old_point;
    BOOL we_are_drawing;
public:
    CMainWindow();
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);

    DECLARE_MESSAGE_MAP()
};

CMainWindow::CMainWindow()
{
    Create(NULL, "Scribble", WS_OVERLAPPEDWINDOW, 
        rectDefault, NULL, NULL);
}

void CMainWindow::OnLButtonDown(UINT nFlags, CPoint point)
{
    old_point = point;
    we_are_drawing = TRUE;
}

void CMainWindow::OnLButtonUp(UINT nFlags, CPoint point)
{
    we_are_drawing = FALSE;
}

void CMainWindow::OnMouseMove(UINT nFlags, CPoint point)
{
    if(we_are_drawing){
        CClientDC dc(this); 

        dc.MoveTo(old_point);
        dc.LineTo(point);
        old_point = point;
    }
}

BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
    ON_WM_LBUTTONDOWN()
    ON_WM_LBUTTONUP()
    ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()

class CTheApp : public CWinApp
{
public:
    BOOL InitInstance();
};

BOOL CTheApp::InitInstance()
{
    m_pMainWnd = new CMainWindow();
    m_pMainWnd->ShowWindow( m_nCmdShow );
    m_pMainWnd->UpdateWindow();

    return TRUE;
}

CTheApp theApp;


