#include <afxwin.h>
#define IDM_ADDNAME   100

class CMainWindow : public CFrameWnd
{
private:
    int nameindex; 
    CString out_string;
    CString Names[10];
public:
    CMainWindow();                                              
    afx_msg void OnChar(UINT wChar, UINT nRepCnt, UINT wFlags); 
    BOOL OnCommand(UINT wParam, LONG lParam);
                                                                
    DECLARE_MESSAGE_MAP()                                       
};

CMainWindow::CMainWindow()
{
    nameindex = 0;
    Create(NULL, "Menu Application",
       WS_OVERLAPPEDWINDOW, rectDefault, NULL, "MainMenu");
}

void CMainWindow::OnChar(UINT wChar, UINT nRepCnt, UINT wFlags)
{
    CClientDC dc(this);
    CString in_char = wChar;
    CSize char_size;

    out_string += in_char;
    dc.TextOut(0, 0, out_string, out_string.GetLength());
}

BOOL CMainWindow::OnCommand(UINT wParam, LONG lParam)
{
    DWORD crOldTextColor;

    if(wParam == IDM_ADDNAME){
        CClientDC dc(this);
        crOldTextColor = dc.SetTextColor(dc.GetBkColor());
        dc.TextOut(0, 0, out_string, out_string.GetLength());
        dc.SetTextColor(crOldTextColor);        
        CMenu* pMenuBar = GetMenu();
        CMenu* pMenu = pMenuBar->GetSubMenu(0);
        //To add item to menu bar, use pMenuBar, not pMenu
        pMenu->AppendMenu(MF_STRING, nameindex, out_string.Left(10));
        DrawMenuBar();
        Names[nameindex] = out_string;         
        nameindex++;
        out_string.Empty();
    }
    else{
        CClientDC dc(this);                                        
    
        crOldTextColor = dc.SetTextColor(dc.GetBkColor());
        dc.TextOut(0, 0, out_string, out_string.GetLength());
        dc.SetTextColor(crOldTextColor);        
        out_string = Names[wParam];
        dc.TextOut(0, 0, out_string, out_string.GetLength());
    }
        return TRUE;
}

BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
    ON_WM_CHAR()
END_MESSAGE_MAP()

class CTheApp : public CWinApp
{
public:
    BOOL InitInstance();
};

BOOL CTheApp::InitInstance()
{
 m_pMainWnd = new CMainWindow();
 m_pMainWnd->ShowWindow( m_nCmdShow );
 m_pMainWnd->UpdateWindow();

 return TRUE;
}

CTheApp theApp;



