#include <afxwin.h>
#include <windows.h>
#include "paint.h"

class CMainWindow : public CFrameWnd
{
private:
    int xAnchor;
    int yAnchor;
    int xold;
    int yold;
    BOOL bPoint;
    BOOL bDraw;
    BOOL bLine;
    BOOL bRectangle;
    BOOL bEllipse;
    BOOL bFill;
    void CheckOnlyMenuItem(int item_to_check);
public:
    CMainWindow();
    afx_msg void OnNew();
    afx_msg void OnExit();
    afx_msg void OnPoint();
    afx_msg void OnDraw();
    afx_msg void OnLine();
    afx_msg void OnRectangle();
    afx_msg void OnEllipse();
    afx_msg void OnFill();
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);

    DECLARE_MESSAGE_MAP()
};

CMainWindow::CMainWindow()
{
    Create(NULL, "Paint", WS_OVERLAPPEDWINDOW, 
        rectDefault, NULL, "MainMenu");
    bPoint = TRUE;
}

void CMainWindow::OnNew()
{
    InvalidateRect(NULL, TRUE);
    UpdateWindow();
}
void CMainWindow::OnExit()
{
    DestroyWindow();
}
void CMainWindow::OnPoint()
{
    CheckOnlyMenuItem(IDM_POINT);
    bPoint = TRUE;
    bDraw = FALSE;
    bLine = FALSE;
    bRectangle = FALSE;
    bEllipse = FALSE;
    bFill = FALSE;
}
void CMainWindow::OnDraw()
{
    CheckOnlyMenuItem(IDM_DRAW);
    bPoint = FALSE;
    bDraw = TRUE;
    bLine = FALSE;
    bRectangle = FALSE;
    bEllipse = FALSE;
    bFill = FALSE;
}
void CMainWindow::OnLine()
{
    CheckOnlyMenuItem(IDM_LINE);
    bPoint = FALSE;
    bDraw = FALSE;
    bLine = TRUE;
    bRectangle = FALSE;
    bEllipse = FALSE;
    bFill = FALSE;
}
void CMainWindow::OnRectangle()
{
    CheckOnlyMenuItem(IDM_RECTANGLE);
    bPoint = FALSE;
    bDraw = FALSE;
    bLine = FALSE;
    bRectangle = TRUE;
    bEllipse = FALSE;
    bFill = FALSE;
}
void CMainWindow::OnEllipse()
{
    CheckOnlyMenuItem(IDM_ELLIPSE);
    bPoint = FALSE;
    bDraw = FALSE;
    bLine = FALSE;
    bRectangle = FALSE;
    bEllipse = TRUE;
    bFill = FALSE;
}
void CMainWindow::OnFill()
{
    CheckOnlyMenuItem(IDM_FILL);
    bPoint = FALSE;
    bDraw = FALSE;
    bLine = FALSE;
    bRectangle = FALSE;
    bEllipse = FALSE;
    bFill = TRUE;
}

void CMainWindow::CheckOnlyMenuItem(int item_to_check)
{
    CMenu* pMenu = GetMenu();
    pMenu->CheckMenuItem(IDM_POINT, MF_UNCHECKED);
    pMenu->CheckMenuItem(IDM_DRAW, MF_UNCHECKED);
    pMenu->CheckMenuItem(IDM_LINE, MF_UNCHECKED);
    pMenu->CheckMenuItem(IDM_RECTANGLE, MF_UNCHECKED);
    pMenu->CheckMenuItem(IDM_ELLIPSE, MF_UNCHECKED);
    pMenu->CheckMenuItem(IDM_FILL, MF_UNCHECKED);
    pMenu->CheckMenuItem(item_to_check, MF_CHECKED);
}

void CMainWindow::OnLButtonDown(UINT nFlags, CPoint point)
{
     xAnchor = point.x;
     yAnchor = point.y;
     xold = xAnchor;
     yold = yAnchor;
}

void CMainWindow::OnLButtonUp(UINT nFlags, CPoint point)
{
     CGdiObject* pBackup; 

     if(bPoint){
      CClientDC dc(this);
      dc.SetPixel(point.x, point.y, RGB(0, 0, 0));
     }
     if(bLine){
      CClientDC dc(this);
      dc.MoveTo(xAnchor, yAnchor);
      dc.LineTo(point.x, point.y);
     }
     if(bRectangle){
      CClientDC dc(this);
      pBackup = dc.SelectStockObject(NULL_BRUSH);
      dc.Rectangle(xAnchor, yAnchor, point.x, point.y);
      dc.SelectObject(pBackup);
     }
     if(bEllipse){
      CClientDC dc(this);
      pBackup = dc.SelectStockObject(NULL_BRUSH);
      dc.Ellipse(xAnchor, yAnchor, point.x, point.y);
      dc.SelectObject(pBackup);
     }
     if(bFill){
      CClientDC dc(this);
      dc.SetROP2(R2_BLACK);
      dc.FloodFill(point.x, point.y, RGB(0, 0, 0));
     }
}

void CMainWindow::OnMouseMove(UINT nFlags, CPoint point)
{
     CGdiObject* pBackup;
     int nDrawMode;

     if((nFlags && MK_LBUTTON) && bDraw){
      CClientDC dc(this);
      dc.MoveTo(xAnchor, yAnchor);
      dc.LineTo(point.x, point.y);
      xAnchor = point.x;
      yAnchor = point.y;
     }
     if((nFlags && MK_LBUTTON) && bLine){
      CClientDC dc(this);
      nDrawMode = dc.GetROP2();
      dc.SetROP2(R2_NOT);
      dc.MoveTo(xAnchor, yAnchor);
      dc.LineTo(xold, yold);
      dc.MoveTo(xAnchor, yAnchor);
      dc.LineTo(point.x, point.y);
      xold = point.x;
      yold = point.y;
      dc.SetROP2(nDrawMode);
     }
     if((nFlags && MK_LBUTTON) && bRectangle){
      CClientDC dc(this);
      nDrawMode = dc.GetROP2();
      dc.SetROP2(R2_NOT);
      pBackup = dc.SelectStockObject(NULL_BRUSH);
      dc.Rectangle(xold, yold, xAnchor, yAnchor);
      dc.Rectangle(xAnchor, yAnchor, point.x, point.y);
      dc.SelectObject(pBackup);
      xold = point.x;
      yold = point.y;
      dc.SetROP2(nDrawMode);
     }
     if((nFlags && MK_LBUTTON) && bEllipse){
      CClientDC dc(this);
      nDrawMode = dc.GetROP2();
      dc.SetROP2(R2_NOT);
      pBackup = dc.SelectStockObject(NULL_BRUSH);
      dc.Ellipse(xold, yold, xAnchor, yAnchor);
      dc.Ellipse(xAnchor, yAnchor, point.x, point.y);
      dc.SelectObject(pBackup);
      xold = point.x;
      yold = point.y;
      dc.SetROP2(nDrawMode);
     }
}

BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
    ON_COMMAND(IDM_NEW, OnNew)
    ON_COMMAND(IDM_EXIT, OnExit)
    ON_COMMAND(IDM_POINT, OnPoint)
    ON_COMMAND(IDM_DRAW, OnDraw)
    ON_COMMAND(IDM_LINE, OnLine)
    ON_COMMAND(IDM_RECTANGLE, OnRectangle)
    ON_COMMAND(IDM_ELLIPSE, OnEllipse)
    ON_COMMAND(IDM_FILL, OnFill)
    ON_WM_LBUTTONDOWN()
    ON_WM_LBUTTONUP()
    ON_WM_MOUSEMOVE()
END_MESSAGE_MAP()

class CTheApp : public CWinApp
{
public:
    BOOL InitInstance();
};

BOOL CTheApp::InitInstance()
{
    m_pMainWnd = new CMainWindow();
    m_pMainWnd->ShowWindow(m_nCmdShow);
    m_pMainWnd->UpdateWindow();

    return TRUE;
}

CTheApp theApp;



