#include <afxwin.h>
#include <windows.h>

class CMainWindow : public CFrameWnd
{
private:
    int caret_x;
    int caret_y;
    int origin_x;
    int origin_y;
public:
    CMainWindow();
    afx_msg void OnChar(UINT wChar, UINT nRepCnt, UINT wFlags);
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);

    DECLARE_MESSAGE_MAP()
};

CMainWindow::CMainWindow()
{
    Create(NULL, "Mouse Input Example", WS_OVERLAPPEDWINDOW, 
        rectDefault, NULL, NULL);
}

void CMainWindow::OnLButtonDown(UINT nFlags, CPoint point)
{
    origin_x = point.x;
    origin_y = point.y;
    caret_x = caret_y = 0;
    HideCaret();
    SetCaretPos(point);
    ShowCaret();
}

int CMainWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    POINT pt;
    CClientDC dc(this);
    TEXTMETRIC tm;

    dc.GetTextMetrics(&tm);
    CreateSolidCaret(tm.tmAveCharWidth/8, tm.tmHeight); 
    pt.x = pt.y = 0;
    SetCaretPos(pt);
    ShowCaret();
    return 0;
}

void CMainWindow::OnChar(UINT wChar, UINT nRepCnt, UINT wFlags)
{
    TEXTMETRIC tm;
    CClientDC dc(this);
    CString in_char = wChar;
    CSize char_size;
    POINT pt;

    HideCaret();

    if(wChar == (UINT) '\r'){
        dc.GetTextMetrics(&tm);
        caret_y += tm.tmHeight;
        caret_x = 0;
    }
    else{
        dc.TextOut(origin_x+caret_x, origin_y+caret_y, in_char, 1);
        char_size = (dc.GetTextExtent(in_char, 1));
        caret_x += char_size.cx;
    }
    pt.x = caret_x+origin_x;
    pt.y = caret_y+origin_y;
    SetCaretPos(pt);
    ShowCaret();
}

BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
    ON_WM_CHAR()
    ON_WM_CREATE()
    ON_WM_LBUTTONDOWN()
END_MESSAGE_MAP()

class CTheApp : public CWinApp
{
public:
    BOOL InitInstance();
};

BOOL CTheApp::InitInstance()
{
    m_pMainWnd = new CMainWindow();
    m_pMainWnd->ShowWindow( m_nCmdShow );
    m_pMainWnd->UpdateWindow();

    return TRUE;
}

CTheApp theApp;


