#include <afxwin.h>
#define IDM_HELLO   100
#define IDM_EXIT    200

class CMainWindow : public CFrameWnd
{
public:
  CMainWindow();
  afx_msg void OnHello();
  afx_msg void OnExit();

  DECLARE_MESSAGE_MAP()
};

CMainWindow::CMainWindow()
{
 LoadAccelTable("MainAccelTable");
 Create(NULL, "Menu Application",
   WS_OVERLAPPEDWINDOW, rectDefault, NULL, "MainMenu");
}

void CMainWindow::OnHello()
{
 CString out_string = "Hello, world.";
 CClientDC dc(this);
 CRect rect;

 GetClientRect(rect);
 dc.SetTextAlign(TA_BASELINE | TA_CENTER);
 dc.SetBkMode(TRANSPARENT);
 dc.TextOut((rect.right / 2), (rect.bottom / 2), out_string, 
        out_string.GetLength() );
 CMenu* pMenu = GetMenu();
 pMenu->EnableMenuItem(IDM_HELLO, MF_GRAYED);
}

void CMainWindow::OnExit()
{
    DestroyWindow();
}

BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
 ON_COMMAND(IDM_HELLO, OnHello)
 ON_COMMAND(IDM_EXIT, OnExit)
END_MESSAGE_MAP()

class CTheApp : public CWinApp
{
public:
  BOOL InitInstance();
};

BOOL CTheApp::InitInstance()
{
 m_pMainWnd = new CMainWindow();
 m_pMainWnd->ShowWindow( m_nCmdShow );
 m_pMainWnd->UpdateWindow();

 return TRUE;
}

CTheApp theApp;



