#include <afxwin.h>
#include "clip.h"

class CMainWindow : public CFrameWnd
{
     CString out_string;
public:
     CMainWindow();
     afx_msg void OnCopyToClipBoard();
     afx_msg void OnPasteFromClipBoard();
     afx_msg void OnChar(UINT wChar, UINT nRepCnt, UINT wFlags); 
     afx_msg void OnExit();

     DECLARE_MESSAGE_MAP()
};

CMainWindow::CMainWindow()
{
    Create(NULL, "Notepad Application",
       WS_OVERLAPPEDWINDOW, rectDefault, NULL, "MainMenu" );
}

void CMainWindow::OnCopyToClipBoard()
{
    HGLOBAL hMem = GlobalAlloc(GMEM_MOVEABLE, out_string.GetLength());
    char far* lpMem = GlobalLock(hMem);
    lstrcpy(lpMem, out_string);
    OpenClipboard();
    EmptyClipboard();
    SetClipboardData(CF_TEXT, hMem);
    GlobalUnlock(hMem);
    CloseClipboard();
}
void CMainWindow::OnPasteFromClipBoard()
{
    CClientDC dc(this);
    TEXTMETRIC tm;
    dc.GetTextMetrics(&tm);
    OpenClipboard();
    HANDLE hClip = GetClipboardData(CF_TEXT);
    char far* lpClip = GlobalLock(hClip);
    dc.TextOut(0, 2 * tm.tmHeight, lpClip, _fstrlen(lpClip));
    GlobalUnlock(hClip);
    CloseClipboard();
}

void CMainWindow::OnChar(UINT wChar, UINT nRepCnt, UINT wFlags)
{
    CClientDC dc(this);
    CString in_char = wChar;
    CSize char_size;

    out_string += in_char;
    dc.TextOut(0, 0, out_string, out_string.GetLength());
}

void CMainWindow::OnExit()
{
    DestroyWindow();
}

BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
    ON_WM_CHAR()
    ON_COMMAND(IDM_F_COPYTOCLIPBOARD, OnCopyToClipBoard)
    ON_COMMAND(IDM_F_PASTEFROMCLIPBOARD, OnPasteFromClipBoard)
    ON_COMMAND(IDM_F_EXIT, OnExit)
END_MESSAGE_MAP()

class CTheApp : public CWinApp
{
public:
    BOOL InitInstance();
};

BOOL CTheApp::InitInstance()
{
    m_pMainWnd = new CMainWindow();
    m_pMainWnd->ShowWindow(m_nCmdShow);
    m_pMainWnd->UpdateWindow();

 return TRUE;
}

CTheApp theApp;


