#include <afxwin.h>
#include <windows.h>

class CMainWindow : public CFrameWnd
{
private:
    int cursor_x;
    int cursor_y;
public:
    CMainWindow();
    afx_msg void OnChar(UINT wChar, UINT nRepCnt, UINT wFlags);

    DECLARE_MESSAGE_MAP()
};

CMainWindow::CMainWindow()
{
    cursor_x = cursor_y = 0;
    Create(NULL, "Character Input Example", WS_OVERLAPPEDWINDOW, 
        rectDefault, NULL, NULL);
}

void CMainWindow::OnChar(UINT wChar, UINT nRepCnt, UINT wFlags)
{
    TEXTMETRIC tm;
    CClientDC dc(this);
    CString in_char = wChar;
    CSize char_size;

    if(wChar == (UINT) '\r'){
        dc.GetTextMetrics(&tm);
        cursor_y += tm.tmHeight;
        cursor_x = 0;
    }
    else{
        dc.TextOut(cursor_x, cursor_y, in_char, 1);
        //cc =dc.GetTextExtent(in_char, 1);
        char_size = (dc.GetTextExtent(in_char, 1));
        cursor_x += char_size.cx;
    }
}

BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
    ON_WM_CHAR()
END_MESSAGE_MAP()

class CTheApp : public CWinApp
{
public:
    BOOL InitInstance();
};

BOOL CTheApp::InitInstance()
{
    m_pMainWnd = new CMainWindow();
    m_pMainWnd->ShowWindow( m_nCmdShow );
    m_pMainWnd->UpdateWindow();

    return TRUE;
}

CTheApp theApp;
