#include <afxwin.h>
#include <windows.h>

class CMainWindow : public CFrameWnd
{
private:
    int cursor_x;
    int cursor_y;
public:
    CMainWindow();
    afx_msg void OnChar(UINT wChar, UINT nRepCnt, UINT wFlags);
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);

    DECLARE_MESSAGE_MAP()
};

CMainWindow::CMainWindow()
{
    POINT pt;
    CClientDC dc(this);
    TEXTMETRIC tm;

    Create(NULL, "Character Input Example", WS_OVERLAPPEDWINDOW, 
        rectDefault, NULL, NULL);

    dc.GetTextMetrics(&tm);
    CreateSolidCaret(tm.tmAveCharWidth/8, tm.tmHeight); 
    pt.x = pt.y = 0;
    SetCaretPos(pt);
    ShowCaret();
}

int CMainWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    //POINT pt;
    //CClientDC dc(this);
    //TEXTMETRIC tm;

    //dc.GetTextMetrics(&tm);
    //CreateSolidCaret(tm.tmAveCharWidth/8, tm.tmHeight); 
    //pt.x = pt.y = 0;
    //SetCaretPos(pt);
    //ShowCaret();
    return 0;
}

void CMainWindow::OnChar(UINT wChar, UINT nRepCnt, UINT wFlags)
{
    TEXTMETRIC tm;
    CClientDC dc(this);
    CString in_char = wChar;
    CSize char_size;
    POINT pt;

    HideCaret();

    if(wChar == (UINT) '\r'){
        dc.GetTextMetrics(&tm);
        cursor_y += tm.tmHeight;
        cursor_x = 0;
    }
    else{
        dc.TextOut(cursor_x, cursor_y, in_char, 1);
        char_size = (dc.GetTextExtent(in_char, 1));
        cursor_x += char_size.cx;
    }
    pt.x = cursor_x;
    pt.y = cursor_y;
    SetCaretPos(pt);
    ShowCaret();
}

BEGIN_MESSAGE_MAP(CMainWindow, CFrameWnd)
    ON_WM_CHAR()
    ON_WM_CREATE()
END_MESSAGE_MAP()

class CTheApp : public CWinApp
{
public:
    BOOL InitInstance();
};

BOOL CTheApp::InitInstance()
{
    m_pMainWnd = new CMainWindow();
    m_pMainWnd->ShowWindow( m_nCmdShow );
    m_pMainWnd->UpdateWindow();

    return TRUE;
}

CTheApp theApp;

