PROGRAM PMTool;


{***************************************************************************
*                                                                          *
*                Speed-Pascal/2 Sample program "PMTool"                    *
*                                                                          *
*           (C) 1993,94 Rene Nrnberger. All rights reserved.              *
*                                                                          *
*                                                                          *
*  This program can be used as a template for your own MDI                 *
*  Applications. It's equal to PmMDI but provides additionaly a Toolbar    *
*  and a Statusline.                                                       *
*                                                                          *
****************************************************************************}


USES Api,PmObject,Crt,PmTypes;    {bind Units used}


RESOURCE PMTOOL;  {bind external Resources}

TYPE
     TMyApplication=OBJECT(TMDIApplication)
                CONSTRUCTOR Init;
                DESTRUCTOR Done;
                FUNCTION HandleEvent(Win:HWND;Msg:ULONG;Para1,Para2:POINTER;
                                     VAR Handled:BOOLEAN):ULONG:VIRTUAL;
                PROCEDURE AppCreateNotify(AppFrWin,AppWin:HWND):VIRTUAL;
     END;

CONST
     CM_NEWCHILD=500;

VAR MyApp:TMyApplication;



{define Methods}

CONSTRUCTOR TMyApplication.Init;
BEGIN
     Inherited.Init;
     InsertResources(TRUE,FALSE,TRUE); {Application has menu and icon}
END;


DESTRUCTOR TMyApplication.Done;
BEGIN
END;

{Virtual Method HandleEvent. All messages come here first}
FUNCTION TMyApplication.HandleEvent(Win:HWND;Msg:ULONG;Para1,Para2:POINTER;
                                    VAR Handled:BOOLEAN):ULONG;
VAR r:LONGWORD;
    H:BOOLEAN;
    Command:WORD;
    fr:ULONG;
    Frame:HWND;
BEGIN
     H:=TRUE;
     r:=Inherited.HandleEvent(Win,Msg,Para1,Para2,Handled);
     CASE Msg OF
         WM_COMMAND:
         BEGIN
              Command:=WORD(Para1);
              CASE Command OF
                  CM_NEWCHILD:
                  BEGIN
                       fr:=FCF_ICON; {MDI window has an icon}
                       Frame:=CreateMDIChild(1001,'MDI Child',NIL,fr,
                                             CLR_BLACK,CLR_CYAN);
                  END;
              END; {case}
         END;
         ELSE IF not handled THEN H:=FALSE;
     END; {Case}
     Handled:=H;
     HandleEvent:=r;
END;

{Virtual Method AppCreateNotify. Called when creating the main window}
PROCEDURE TMyApplication.AppCreateNotify(AppFrWin,AppWin:HWND);
BEGIN
     Inherited.AppCreateNotify(AppFrWin,AppWin);
     WinSetWindowPos(SWP_SPEED,400,500,50,50,HWND_TOP,AppFrWin);
     CreateToolBar(30);
     ToolBarInsertButton(CM_NEWCHILD,2000,10,3,28,24);
     ToolBarInsertButton(CM_TILE,2001,45,3,28,24);
     ToolBarInsertButton(CM_CASCADE,2002,80,3,28,24);
     CreateStatusBar(30);
     StatusBarInsertItem(1,10,3,620,16);
     InsertMenuHelp(1,65535,'',-1);  {Default menu help}
     InsertMenuHelp(1,CM_NEWCHILD,'Create a new MDI child window',-1);
     InsertMenuHelp(1,CM_CLOSE,'Close the active MDI child window',-1);
     InsertMenuHelp(1,CM_CLOSEALL,'Close all MDI child windows',-1);
     InsertMenuHelp(1,CM_TILE,'Arrange MDI child windows by tiling',-1);
     InsertMenuHelp(1,CM_CASCADE,'Arrange MDI child windows by cascading',-1);
     InsertMenuHelp(1,CM_NEXT,'Display next MDI child window',-1);
END;


BEGIN  {Main}
     MyApp.Init;
     MyApp.Run(1000,'PMTool Sample Application',CLR_DARKGRAY,CLR_WHITE);
     MyApp.Done;
END.
































































 



























 



























 































































 



























 














































 



























 
























































