UNIT RcMenu;

INTERFACE

USES RcTypes;

VAR
    TempMenu:PMenu;

CONST
    MenuCount:Word=0;


    MenuStyles:ARRAY[1..14] OF TStyle=(
    (Name:'MIS_TEXT';Style:$0001),
    (Name:'MIS_BITMAP';Style:$0002),
    (Name:'MIS_SEPARATOR';Style:$0004),
    (Name:'MIS_OWNERDRAW';Style:$0008),
    (Name:'MIS_SUBMENU';Style:$0010),
    (Name:'MIS_MULTMENU';Style:$0020),
    (Name:'MIS_SYSCOMMAND';Style:$0040),
    (Name:'MIS_HELP';Style:$0080),
    (Name:'MIS_STATIC';Style:$0100),
    (Name:'MIS_BUTTONSEPARATOR';Style:$0200),
    (Name:'MIS_BREAK';Style:$0400),
    (Name:'MIS_BREAKSEPARATOR';Style:$0800),
    (Name:'MIS_GROUP';Style:$1000),
    (Name:'MIS_SINGLE';Style:$2000));

    MenuAttribs:ARRAY[1..5] OF TStyle=(
    (Name:'MIA_NODISMISS';Style:$0020),
    (Name:'MIA_FRAMED';Style:$1000),
    (Name:'MIA_CHECKED';Style:$2000),
    (Name:'MIA_DISABLED';Style:$4000),
    (Name:'MIA_HILITED';Style:$8000));


PROCEDURE ParseMenu;
PROCEDURE Write_res_Menus;
PROCEDURE Write_Menus;

IMPLEMENTATION

PROCEDURE WriteSubMenu(m,m1:PMenu);
BEGIN
     while m1<>NIL do
     begin
          IF m1^.SubMenus<>NIL THEN
          BEGIN
               m1^.Style:=m1^.Style and 65531; {no separators}
               WriteWord(m1^.Style);
               WriteWord(m1^.Attrib);
               WriteWord(m1^.ident);
               WriteStr(m1^.MenuName);

               WriteWord(m1^.SubSize AND 65535);
               WriteWord(m1^.SubSize SHR 16);
               WriteWord($0352);
               WriteWord(4);
               WriteWord(m1^.SubCount);
               WriteSubMenu(m1,m1^.SubMenus);
          END
          ELSE
          BEGIN
               IF m1^.Style AND 4=4 THEN {Separator}
               BEGIN
                    writeWord(4);
                    writeWord(0);
                    writeWord($ffff);
               END
               ELSE
               BEGIN
                    writeword(m1^.Style);
                    writeword(m1^.Attrib);
                    writeword(m1^.ident);
                    writestr(m1^.menuname);
               END;
          END;
          m1:=m1^.next;  {Next submenu entry}
     end;
END;


PROCEDURE Write_res_Menus;
var m,m1,m2:PMenu;
    b:byte;
    l:Longint;
BEGIN
     m2:=Menus;
     if m2=NIL then exit;
     while m2<>NIL do   {alle Menus}
     begin
          l:=m2^.subsize;   {Overall Size of the menu bar}
          m:=m2;
          if m<>NIL THEN  {If there is at least one menu entry}
          BEGIN
               WriteWord(l mod 65536);
               WriteWord(l div 65536);
               WriteWord($0352);
               WriteWord(4);
               WriteWord(m^.subcount);
          END;

          m:=m^.SubMenus;   {Main menu entries}
          while m<>NIL do   {all main menu entries}
          begin
              m^.Style:=m^.Style and 65531; {no separators}
              WriteWord(m^.Style);
              WriteWord(m^.Attrib);
              WriteWord(m^.ident);
              WriteStr(m^.MenuName);
              m1:=m^.SubMenus;  {Submenu entries}
              if m1<>NIL then
              BEGIN
                   writeword(m^.subsize mod 65536);
                   writeword(m^.subsize div 65536);
                   writeword($0352);
                   writeword(4);
                   writeword(m^.subcount);
                   WriteSubMenu(m,m1)
              END
              ELSE   {No Submenu entry for this}
              BEGIN
                 WriteWord($0a);
                 WriteWord(0);
                 WriteWord($0352);
                 WriteWord(4);
                 WriteWord(0);
              END;
              m:=m^.next;   {Next Main menu entry}
        end; {While main menu<>NIL}
        writeword(0);
        m2:=m2^.next;  {Next menu bar}
     END;
END;


PROCEDURE Write_Menus;
VAR w:Word;
    m:PMenu;
BEGIN
     MenuOffset:=IconOffset;
     {Nun die Bezeichner der Menus}
     m:=Menus;
     while m<>NIL do
     begin
          WriteWord(3);                     {Typ:Menu}
          writeword(m^.ident);              {Bezeichner des Menus}
          writeword(m^.subsize AND 65535);  {Lnge der Eintrge fr dieses Menu}
          writeword(m^.subsize SHR 16);
          writeWord(3);                     {Object number}
          writeWord(MenuOffset AND 65535);  {Relativer Resourcenoffset}
          writeWord(MenuOffset SHR 16);
          inc(MenuOffset,m^.SubSize);
          m:=m^.next;
     end;
END;

PROCEDURE NewMenu(VAR m,m1:PMenu;DefaultStyle:WORD);
Var spos:Byte;
BEGIN
     IF m=NIL THEN
     BEGIN
          New(m);
          m1:=m;
     END
     ELSE
     BEGIN
          m1:=m;
          while m1^.next<>NIL do m1:=m1^.next;
          new(m1^.next);
          m1:=m1^.next;
     END;
     m1^.MenuName:=params;
     m1^.SubCount:=0;
     m1^.SubMenus:=NIL;
     m1^.SubSize:=0;
     m1^.Style:=DefaultStyle;
     m1^.Attrib:=0;
     m1^.Next:=NIL;
END;


PROCEDURE SubMenuSize(m:PMenu;VAR s:WORD);
BEGIN
     WHILE m<>NIL DO   {all submenu entries}
     BEGIN
          IF m^.SubMenus<>NIL THEN  {weitere Submenueintrge}
          BEGIN
               s:=s+7+length(m^.Menuname);
               s:=s+10;
               SubMenuSize(m^.SubMenus,s);
          END
          ELSE
          BEGIN
               IF m^.Style AND 4=4 THEN s:=s+6 {Separator}
               ELSE s:=s+7+length(m^.menuname);
          END;
          m:=m^.next;
     END;
END;


PROCEDURE MenuSize(m:PMenu;VAR s,s1:WORD);
BEGIN
     s1:=s;
     IF m^.SubMenus<>NIL THEN  {1. Untermenu}
     BEGIN
         s:=s+10;
         SubMenuSize(m^.SubMenus,s);
     END
     ELSE s:=s+10;  {No first SubMenu entries}
     m^.SubSize:=s-s1;
END;

PROCEDURE Calc_MenuSize(VAR m:PMenu);
var m1,m2:PMenu;
    s,s1:word;
BEGIN
     if m=NIL then exit;
     s:=12;  {Size without anything for every menubar}
     m1:=m^.SubMenus;    {Main menu entries}
     while m1<>NIL do   {all SubMenus}
     begin
          s:=s+7+length(m1^.MenuName);  {Main menu entry}
          MenuSize(m1,s,s1);
          m1:=m1^.next;    {Next main menu}
     end;
     m^.SubSize:=s;      {overall size}
END;

PROCEDURE GetMenuAttribs(VAR s:string;m:PMenu);
VAR t:BYTE;
    params,temp:STRING;
Label l;
BEGIN
     SplitLine(s,params,',');
l:
     SplitLine(Params,Temp,'|');
     FOR t:=1 TO length(Temp) DO Temp[t]:=upcase(temp[t]);
     FOR t:=1 TO 14 DO
     BEGIN
          IF MenuAttribs[t].Name=temp THEN
          BEGIN
               m^.Attrib:=m^.Attrib or MenuAttribs[t].Style;
               IF params<>'' THEN goto l;
               exit;
          END;
     END;
     Error('Illegal menu attribute:'+temp);
END;





PROCEDURE GetMenuStyles(VAR s:string;m:PMenu);
VAR t:BYTE;
    params,temp:STRING;
Label l;
BEGIN
     SplitLine(s,params,',');
l:
     SplitLine(Params,Temp,'|');
     FOR t:=1 TO length(Temp) DO Temp[t]:=upcase(temp[t]);
     FOR t:=1 TO 14 DO
     BEGIN
          IF MenuStyles[t].Name=temp THEN
          BEGIN
               m^.Style:=m^.Style or MenuStyles[t].Style;
               IF params<>'' THEN goto l;
               exit;
          END;
     END;
     Error('Illegal menu style:'+temp);
END;

PROCEDURE ReadMenu(VAR m:PMenu);
VAR s:string;
    m1:PMenu;
    c:Integer;
    i:WORD;
    i1:LONGINT;
BEGIN
     Read_Line;
     if commanditem<>__BEGIN then error('BEGIN expected');
     while commanditem<>__END do
     begin
          Read_line;
          case commanditem of
            __END: ;
            ELSE
            begin
                 case commanditem of
                   __SUBMENU:
                   BEGIN
                        inc(m^.subcount);
                        s:=params;
                        SplitLine(s,params,',');
                        IF Params[1]<>'"' THEN error('Syntax error');
                        IF Params[length(Params)]<>'"' THEN error('Syntax error');
                        dec(Params[0]);
                        delete(Params,1,1);
                        NewMenu(m^.SubMenus,m1,$10);
                        SplitLine(s,params,',');
                        val(params,m1^.ident,c);
                        if c<>0 then
                        BEGIN
                             IF not SearchConstant(params,i1) THEN
                                error('Illegal numeric format');
                             m1^.ident:=i1;
                        END;
                        IF s='' THEN m1^.Style:=m1^.Style or 1 {MIS_TEXT}
                        ELSE GetMenuStyles(s,m1);
                        IF s<>'' THEN Error('Syntax error');
                        ReadMenu(m1);
                   END;
                   __MENUITEM:
                   BEGIN
                        inc(m^.subcount);
                        s:=params;
                        IF s='SEPARATOR' THEN
                        BEGIN
                             Params:='';
                             NewMenu(m^.SubMenus,m1,0);
                             m1^.Style:=4; {MIS_SEPARATOR}
                        END
                        ELSE
                        BEGIN
                             SplitLine(s,params,',');
                             IF Params[1]<>'"' THEN error('Syntax error');
                             IF Params[length(Params)]<>'"' THEN error('Syntax error');
                             dec(Params[0]);
                             delete(Params,1,1);
                             NewMenu(m^.SubMenus,m1,0);
                             SplitLine(s,params,',');
                             val(params,m1^.ident,c);
                             if c<>0 then
                             BEGIN
                                 IF not SearchConstant(params,i1) THEN
                                  error('Illegal numeric format');
                                 m1^.ident:=i1;
                             END;
                             IF s='' THEN m1^.Style:=m1^.Style or 1 {MIS_TEXT}
                             ELSE GetMenuStyles(s,m1);
                             IF s<>'' THEN GetMenuAttribs(s,m1);
                             IF s<>'' THEN Error('Syntax error');
                         END;
                   END;
                   else error('Unknown command '+command);
                 end; {case}
            end;
          end; {case}
     end;
     CommandItem:=__BEGIN;
END;


PROCEDURE ParseMenu;
VAR m:PMenu;
    i:WORD;
    memopt:WORD;
    c:Integer;
    s,s1:string;
    i1:LONGINT;
Label l;
BEGIN
     INC(MenuCount);
     val(params,i,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(params,i1) THEN
            error('Illegal numeric format');
          i:=i1;
     END;
     params:='';
     NewMenu(Menus,m,$11);
     m^.ident:=i;
     ReadMenu(m);
     Calc_MenuSize(m);
END;


BEGIN
END.