/* Create RUNSTATS for CELDIAL tables */
/*************************************************************************
   Written by Stuart Colvin, Informational Tools Development,
              SWS Santa Teresa Laboratory
              March 1994
**************************************************************************/
/* Enhancements, fixes, etc.
 * Mar 25 - convert to CEL prefix (SG)
 * Jun  8 - add PRODINV table (SG)
 *************************************************************************/
/************************************************
  Initialize required variables
 ************************************************/
 True=(1=1); False=(0=1)
/**************************************************************
   Register SQLEXEC routine
 **************************************************************/
 If Rxfuncquery('SQLEXEC') <>0 then
    do; rcy = Rxfuncadd('SQLEXEC','SQLAR','SQLEXEC')
   /*   say 'RC from Rxfuncadd is' rcy  */
        end
 parse upper arg nolog nexttab debug
 if debug='DEBUG' then debug=true; else debug=false
/**************************************************************
   Identify user & connect to database before using DBM calls
 **************************************************************/
if nolog <> 'NOLOG' then call connect

if (nexttab <> '' & nexttab <> '.') then interpret 'signal' nexttab

CUSTOMER:
      call RunStat 'CUSTOMER'
      call RunStat 'CUSTSHIP'
      if (nexttab <> '' & nexttab <> '.') then signal commexit
PRODUCT:
      call RunStat 'PRODUCT'
      call RunStat 'PRODSHOW'
      call RunStat 'PRODINV'
      if (nexttab <> '' & nexttab <> '.') then signal commexit
COMPONENTS:
      call RunStat 'PRODCOMP'
      call RunStat 'COMPONENTS'
      if (nexttab <> '' & nexttab <> '.') then signal commexit
ORDERS:
      call RunStat 'ORDER_SUMMARY'
      call RunStat 'ORDER_DETAIL'
      call RunStat 'ORDER_HIST_SUM'
      call RunStat 'ORDER_HIST_DET'
      if (nexttab <> '' & nexttab <> '.') then signal commexit
ARHIST:
      call RunStat 'AR_HISTORY'
      if (nexttab <> '' & nexttab <> '.') then signal commexit

commexit:
      call SQLEXEC 'COMMIT'
      exit 0
/*************end-of-mainline *********************/

connect:
/**************************************************************
   Identify user & connect to database before using DBM calls
 **************************************************************/
'@ECHO OFF';
 say 'Logging on as USERID locally'
'LOGON USERID /L /P='
 if rc<>0 then do;
    say 'Logon failed, RC='rc', fix & restart'
    exit
    end

 say 'Connecting to CELDIAL database'
 call DBM '-O CONNECT TO CELDIAL'
 if rc<>0 then do;
    say 'Connect failed, RC='rc', fix & restart'
    exit 4
    end
 return

RunStat:
 arg tabname
 say 'Creating Stats for' tabname 'table'
 call DBM 'RUNSTATS ON TABLE USERID.'tabname 'SHRLEVEL REFERENCE'
 return
