/* Convert data to format specified                           */
/*************************************************************************
   Written by Steve Goldwasser, Marketing Development & Sales,
              PRGS Toronto Laboratory
              March 1994
**************************************************************************/
/* Enhancements, fixes, etc.
 * Jun  8 - add PRODINV table
 *************************************************************************/

 arg format debug
 if format<>'EUR' & format<>'ISO' & format<>'JIS' then ,
    do; say 'In CELCONV, parameter must be EUR, ISO, or JIS'
        exit 8
        end
/************************************************
  Initialize required variables
 ************************************************/
 celback = 'CELDIAL.DAT'  /* Consolidated data file */
 interpret 'celdata = ''CELDIAL.'format''''
 True=(1=1); False=(0=1)
 exitrc = 0
 /* data to be converted */
 tab.1='PRODUCT'    
 tab.2='ORDERS'
 tab.3='ARHIST'
 tab.4='EOF'
 tab.0=4            /* No of data headers defined    */
 if debug='DEBUG' then debug=true
 else debug=false

recni=0                 /* No of records read */
recno=0                 /*  & written         */
exitrc=0                /* starting RC        */
'ERASE' celdata '1> NUL 2>NUL'
'COPY' celback celdata '1> NUL 2>NUL' /* initialize new file, (include '1A'X at end)*/
line=readln()           /* position to first line */
call lineout celdata,,1 /* ditto              */

say; say 'Converting data to' format 'format.'

do tbnum = 1 to tab.0
   if debug then say 'Mainline loop, tbnum='tbnum
   call tabpos(tab.tbnum)
   if exitrc=0 & tbnum<tab.0 then ,
      do; call COMMON(tab.tbnum)
          if exitrc<>0 then leave
          end
   else leave
   end

commexit:
   call linein  celback    /* close the files */
   call lineout celdata
   say
   say 'Records read from 'celback' = 'recni
   say '   (includes headers, comments, & EOF record)'
   say 'Records written to 'celdata' ='recno
   exit exitrc
/*************end-of-mainline *********************/

tabpos:   /* Position to header for specified table(s) */
   arg header
   if debug then say 'In tabpos, looking for header' header
   hdrnomatch = true
   do until \hdrnomatch
      if length(line)<>0 then ,
        do; call writeln line       /* Always write out current line */
            if substr(line,1,2) = '..' then ,
            do; parse value line with '..' headin .
                if headin = header then
                   hdrnomatch = false
                end
            line=readln()           /* get next line ready to inspect */
            end
      else leave            /* EOF - quit trying */
      end /* do forever */
   if length(line)=0 then recni = recni-1 /* adjust for EOF */
   if hdrnomatch then ,
      do; say 'Expected header ..'header' not found before EOF'
          say 'Correct data and rerun'
          exitrc = 8
          end
   if debug then say header recno
   return exitrc

COMMON:    /* Convert data lines */
   arg prodform
   if debug then say 'In COMMON, arg='prodform
   do forever
      if substr(line,1,2)<>'..' & substr(line,1,2)<>'.*' then
         interpret 'lino='prodform'()'
      else lino = line
      if substr(line,1,2)='..' then leave /* process header elsewhere */
      call writeln lino
      line=readln()
      if length(line)=0 then ,
      do; say 'Unexpected EOF, record' recni
          say 'Repair data and rerun'
          exit 8
          end
   end /* do */
   if debug  then say 'Leaving COMMON, line='line
   return

PRODUCT:
      SHIPDATE=substr(line,58,10)
      interpret 'SHIPDATE=date'format'(SHIPDATE)'
      lint=substr(line,1,57)||SHIPDATE||substr(line,68,28)
      return lint

ORDERS:     /* Convert ORDERS data line */
      prefix=substr(line,3,2)
      if prefix='O2' | prefix='H2' then
            lint=line        /* No changes yet for detail lines */
      else ,
        do; ORDERDATE = substr(line,23,10)
            CUSSHPDATE= substr(line,34,10)
            PLNSHPDATE= substr(line,45,10)
            STORACTDTE= substr(line,56,10)
            COMMENT   = substr(line,66,20)
            interpret 'ORDERDATE =date'format'(ORDERDATE)'
            interpret 'CUSSHPDATE=date'format'(CUSSHPDATE)'
            interpret 'PLNSHPDATE=date'format'(PLNSHPDATE)'
            if prefix='H1' then
              interpret 'STORACTDTE=date'format'(STORACTDTE)'
            lint=substr(line,1,22)||ORDERDATE' 'CUSSHPDATE' 'PLNSHPDATE' 'STORACTDTE||COMMENT
            lint=substr(lint,1,length(line))  /* trunc to original length */
            end
      return lint

ARHIST:     /* Convert ARHIST data line */
      INVDATE   = substr(line,14,10)
      RECEIVEDTE= substr(line,43,10)
      interpret 'INVDATE=date'format'(INVDATE)'
      interpret 'RECEIVEDTE=date'format'(RECEIVEDTE)'
      lint=substr(line,1,13)||INVDATE||substr(line,24,19)
      lint=lint||RECEIVEDTE||substr(line,53,6)
      return lint

EOF:
      if debug then say 'In EOF'
      return ' '

dateEUR:
      arg dte
      parse value dte with mm '/' dd '/' yyyy
      dte = dd'.'mm'.'yyyy
      return dte

dateISO:
      nop /* fall through */
dateJIS:
      arg dte
      parse value dte with mm '/' dd '/' yyyy
      dte = yyyy'-'mm'-'dd
      return dte

readln:
   lint = linein(celback)
   recni = recni+1
   if debug then say 'I' recni 'line=|'lint'|'
   return lint

writeln:
   parse arg lint
   call lineout celdata,lint
   Recno = Recno+1
   if debug then say 'O' recno 'line=|'lint'|'
   return
