extern long FAR PASCAL ScreenWndProc(HWND,UINT,WPARAM,LPARAM);

//#define WINMEM

/*
*          Definition of attribute bits in the Virtual Screen
*
*          0   -   Bold
*          1   -   
*          2   -
*          3   -   Underline
*          4   -   Blink
*          5   -
*          6   -   Reverse
*          7   -   Graphics character set
*
*/
#define SCR_isbold(x)   (x & 0x01)
#define SCR_isundl(x)   (x & 0x08)
#define SCR_isblnk(x)   (x & 0x10)
#define SCR_isrev(x)    (x & 0x40)
#define SCR_setrev(x)   (x ^= 0x40)
#define SCR_isgrph(x)   (x & 0x80)
#define SCR_inattr(x)   (x & 0xd9)
#define SCR_graph(x)    (x | 0x80)
#define SCR_notgraph(x) (x & 0x7F)

#define SCREEN_HANDLE            0    /* offset in extra window info */

#define WM_MYSCREENCHAR     0x0066  
#define WM_MYSCREENBLOCK    0x0067
#define WM_MYSYSCHAR        0x0068
#define WM_MYSCREENCLOSE    0x0069
#define WM_MYSCREENCHANGEBKSP 0x0070

#define FRAME_HEIGHT ((2* GetSystemMetrics(SM_CYFRAME))+GetSystemMetrics(SM_CYCAPTION)+GetSystemMetrics(SM_CYMENU))
#define FRAME_WIDTH  (2*GetSystemMetrics(SM_CXFRAME)+GetSystemMetrics(SM_CXVSCROLL))
#define TAB_SPACES 8
#define SPACE 32
#define ALERT 0x21

#ifdef WINMEM
#define HSCREENLINE DWORD
#define LINE_MEM_ALLOC(x) sAlloc(x)
#define LINE_MEM_LOCK(x) (SCREENLINE FAR *)sLock(x)
#define LINE_MEM_UNLOCK(x) sUnlock(x)
#define LINE_MEM_FREE(x) sFree(x)
#else
#define HSCREENLINE HGLOBAL
#define LINE_MEM_ALLOC(x) GlobalAlloc(GHND,x)
#define LINE_MEM_LOCK(x) (SCREENLINE FAR *) GlobalLock(x)
#define LINE_MEM_UNLOCK(x) GlobalUnlock(x)
#define LINE_MEM_FREE(x) GlobalFree(x)
#endif

#define HSCREEN HGLOBAL
#define VSPBOTTOM 24


typedef struct SCREENLINE {
    HSCREENLINE next,prev;
    int width;
    char text[133];  
    char attrib[133];                       
} SCREENLINE;

typedef struct SCREEN {
    LPSTR title;
    HWND hWnd;
    HSCREENLINE screen_top,
                screen_bottom,
                buffer_top,
                buffer_bottom;
/*        **attribute_lines;
*/    int ID,
        type,
        width,
        height,
        allwidth,
        maxwidth,
        maxlines,       //Maximum number of scrollback lines
        numlines,       //Current number of scrollback lines
        savelines,      //Save lines off top?
        Rtop,Rbottom,
        Rleft,Rright,
        ESscroll,       //Scroll screen when ES received
        attrib,         //current attribute
        x,y,            //current cursor position
        Oldx,Oldy,      // internally used to redraw cursor
        Px,Py,Pattrib,  //saved cursor pos and attribute
        VSIDC,          // Insert/Delete character mode 0=draw line
        DECAWM,         // AutoWrap mode 0=off
        DECCKM,         // Cursor key mode
        DECPAM,         // keyPad Application mode
        IRM,            // Insert/Replace mode
        escflg,         // Current Escape level        
        top,bottom,     // Vertical bounds of screen
        parmptr,
        cxChar,         /* Width of the current font */
        cyChar;         /* Height of the current font */
    BOOL bAlert;
    int parms[6];       //Ansi Params
    LOGFONT lf;
    HFONT ghSelectedFont,ghSelectedULFont;
    char *tabs;
    HSCREEN next, prev;
} SCREEN;

typedef struct CONFIG {
    LPSTR title;
    int ID,
        type,
        height,
        width,
        maxlines,       //Maximum number of scrollback lines
        backspace,
        ESscroll,       //Scroll screen when ES received
        VSIDC,          // Insert/Delete character mode 0=draw line
        DECAWM,         // AutoWrap mode 0=off
        IRM;            // Insert/Replace mode
} CONFIG;

#define TELNET_SCREEN   0
#define CONSOLE_SCREEN  1

#define IDM_FONT        100
#define IDM_BACKSPACE   101
#define IDM_DELETE      102

#define IDM_COPY        200
#define IDM_PASTE       201

#define TIMER_TRIPLECLICK 1000

#define IDC_ALLOCFAIL           1
#define IDC_LOCKFAIL            2
#define IDC_LOADSTRINGFAIL      3
#define IDC_FONT                6

#define DESIREDPOINTSIZE 12


void FAR        ReportError(WORD);
LPSTR NEAR AllocAndLockMem(HANDLE *hChunk, WORD wSize);
void NEAR InitializeStruct(WORD wCommDlgType, LPSTR lpStruct, HWND hWnd);
HSCREENLINE ScreenNewLine();
void ScreenBell(SCREEN FAR *fpScr);
void ScreenBackspace(SCREEN FAR * fpScr);
void ScreenTab(SCREEN FAR *fpScr);
void ScreenCarriageFeed(SCREEN FAR *fpScr);
int ScreenScroll(SCREEN far *fpScr);
void DeleteTopLine(SCREEN far *fpScr);
/* emul.c */
void FAR PASCAL ScreenEm(LPSTR c,int len,HSCREEN hsScr);


/* intern.c */
HSCREENLINE GetScreenLineFromY(SCREEN FAR *fpScr,int y);
void ScreenELO(SCREEN FAR *fpScr,int s);
void ScreenEraseScreen(SCREEN FAR *fpScr);
void ScreenTabClear(SCREEN FAR *fpScr);
void ScreenTabInit(SCREEN FAR *fpScr);
void ScreenReset(SCREEN FAR *fpScr);
void ScreenIndex(SCREEN FAR * fpScr);
void ScreenWrapNow(SCREEN FAR *fpScr,int *xp,int *yp);
void ScreenEraseToEOL(SCREEN FAR *fpScr);
void ScreenEraseToBOL(SCREEN FAR *fpScr);
void ScreenEraseLine(SCREEN FAR *fpScr,int s);
void ScreenEraseToEndOfScreen(SCREEN FAR *fpScr);
void ScreenRange(SCREEN FAR *fpScr);
void ScreenAlign(SCREEN FAR *fpScr);
void ScreenApClear(SCREEN FAR *fpScr);
int ScreenInsChar(SCREEN FAR *fpScr,int x);
void ScreenInsString(SCREEN FAR *fpScr,int len,char *start);
void ScreenSaveCursor(SCREEN FAR *fpScr);
void ScreenRestoreCursor(SCREEN FAR *fpScr);
void ScreenDraw(SCREEN FAR *fpScr,int x,int y,int a,int len,char *c);
void ScreenCursorOff(SCREEN FAR *fpScr);
void ScreenCursorOn(SCREEN FAR *fpScr,int x,int y,int ForceMove);
void ScreenRevIndex(SCREEN FAR *fpScr);
void ScreenInsLines(SCREEN FAR *fpScr,int n,int s);

void ProcessFontChange(HWND hWnd);
void Edit_LbuttonDown(HWND hWnd,LPARAM lParam);
void Edit_LbuttonDblclk(HWND hWnd,LPARAM lParam);
void Edit_LbuttonUp(HWND hWnd, LPARAM lParam);
void Edit_TripleClick(HWND hWnd, LPARAM lParam);
void Edit_MouseMove(HWND hWnd, LPARAM lParam);
void Edit_ClearSelection(SCREEN far *fpScr);
void Edit_Copy(HWND hWnd);
void Edit_Paste(HWND hWnd);

extern HSCREEN FAR PASCAL InitNewScreen(CONFIG FAR *Config);
extern int far PASCAL OutScreenLine(char far *text, HSCREEN hsScr);
extern int far PASCAL OutScreenChar(char ch, HSCREEN hsScr);


