
#ifndef EXTERNS_H

#define MOUSE

/* net.c */
#include "protocol.h"
extern  void statcheck(void );
extern  int netparms(uint irq,uint address,uint ioaddr);
extern  void netconfig(char *s);
extern  void pcgetaddr(char *s,int x,int y);

/* user.c */
extern  int netread(int pnum,char *buffer,int n);
extern  int netwrite(int pnum,char *buffer,int n);
extern  int netpush(int pnum);
extern  int netqlen(int pnum);
extern  int netroom(int pnum);
extern  int netsegsize(int newsize);
extern  int netquench(int newcredit);
extern  void netarptime(int t);
extern  void netsetip(unsigned char *st);
extern  void netgetip(unsigned char *st);
extern  void netsetbroad(unsigned char *st);
extern  void netsetmask(unsigned char *st);
extern  void netgetmask(unsigned char *st);
extern  void netfromport(int port);
extern  int netest(int pn);
extern  int netlisten(unsigned int serv);
extern  void netgetftp(int a[],int pnum);
extern  int netopen(unsigned char *s,unsigned int tport);
extern  int netxopen(unsigned char *machine,unsigned int service,unsigned int rto,unsigned int mtu,unsigned int mseg,unsigned int mwin);
extern  int doconnect(int pnum,int service,int mseg);
extern  int netopen2(int pnum);
extern  int netclose(int pnum);
extern  int netinit(void );
extern  void netshut(void );

/* tools.c */
extern  int netsleep(int n);
extern  int enqueue(struct window *wind,char *buffer,int nbytes);
extern  int dequeue(struct window *wind,char *buffer,int nbytes);
extern  int rmqueue(struct window *wind,int nbytes);
extern  int transq(struct port *prt);
extern  void netposterr(int num);
extern  int netgetevent(unsigned char mask,int *retclass,int *retint);
extern  int netputevent(int class,int what,int dat);
extern  int netputuev(int class,int what,int dat);
extern  char *neterrstring(int errno);

/* domain.c */
#include "domain.h"
extern  void qinit(void );
extern  void sendom(char *s,char *towho,int num);
extern  int Sdomain(char *mname);
extern  int udpdom(void );
extern  int domto(int num);
extern  int ddextract(struct useek *qp,unsigned char *mip);

extern  int Sfwrite(int pnum,char *buf,int nsrc);
extern  int Sfread(int pnum,char *buf,int nwant);
extern  void Sftpname(char *s);
extern  void Sftpuser(char *user);
extern  void Sftphost(char *host);
extern  void Sftpstat(long *byt);

/* util.c */
#include "hostform.h"
extern  int Snetinit(void );
extern  int Snetopen(struct machinfo *m,int tport);
extern  void Scwritemode(int mode);
extern  int Scmode(void );
extern  void Stekmode(int mode);
extern  int Stmode(void );
extern  void Srcpmode(int mode);
extern  int Srmode(void );
extern  int Sftpmode(int mode);
extern  int Sfmode(void );
extern  int Snewcap(char *s);
extern  int Snewpsfile(char *s);
extern  int Snewhpfile(char *s);
extern  int Snewtekfile(char *s);
extern  int Snewkbfile(char *s);
#ifdef MSC
#ifdef __TURBOC__
#include <stdio.h>
extern  FILE *Sopencap(void );
#else
extern  struct _iobuf *Sopencap(void );
#endif
#else
#include <stdio.h>
extern	FILE *Sopencap(void );
#endif
extern  void Stask(void );
extern  int Stimerset(int class,int event,int dat,int howlong);
extern  int Stimerunset(unsigned char class,unsigned char event,int dat);
extern  int Scheckpass(char *us,char *ps);
extern  int Sneedpass(void );
extern  int Scompass(char *ps,char *en);
extern  int Sgetevent(int class,int *what,int *datp);
extern 	char *fixdirnm(char *name);

/* confile.c */
extern  void Sgetconfig(struct config *cp);
extern  int Sreadhosts(void );
extern  int ncstrcmp(char *sa,char *sb);
extern  void Serrline(int n);
extern  int Scontoken(int c);
extern  int Sconfile(char *s);
extern  void Scopyfrom(char *s);
extern  struct machinfo *Smadd(char *mname);
extern  void Shostfile(char *ptr);
extern  void Shostpath(char *ptr);
extern  struct machinfo *Sgethost(char *machine);
extern  struct machinfo *Shostlook(char *hname);
extern  struct machinfo *Slooknum(int num);
extern  struct machinfo *Slookip(unsigned char *ipnum);
extern  int Sissep(int c);
extern  int Snewns(void );
extern  int Ssetns(unsigned char ipn[4]);
extern  void Ssetgates(void );

/* ipasm.asm */
extern void movebytes(void _far *to,void _far *from,int len);
extern long longswap(long l);
extern unsigned int intswap(int i);
extern int ipcheck(char _far *s,int len);
extern int tcpcheck(char _far *psptr,char _far *tcpptr,int tcplen);
extern void tinst(void );
extern void tdeinst(void );

/* ncsaio.asm */
extern long n_clicks(void );
extern void n_sound(unsigned int freq,unsigned int len);
extern void n_cur(int row,int col);
extern char n_row(void );
extern char n_col(void );
extern void n_cheat(char _far *s,int len);
extern void n_draw(char _far *s,int len);
extern void n_scrup(int num,int ulx,int uly,int lrx,int lry);
extern void n_scrdn(int num,int ulx,int uly,int lrx,int lry);
extern int n_chkchar(void );
extern unsigned int n_getchar(void);
extern void n_putchar(char c);
extern void n_puts(char _far *s);
extern void set_cur(int type);
extern void n_clear(void );
extern void n_window(int uly,int ulx,int lry,int lrx);
extern void ega43(void );
extern int n_scrlck(void );
extern void ega24(void );
extern void n_attr(int );
extern void n_biosattr(int );
extern int n_flags(void );
extern int n_color(int color);
extern int n_findfirst(char _far *name,int type);
extern int n_findnext(void );
extern void clear_int(void );
extern void set_int(void );
extern int n_wrap(int wrap);
extern void save_break(void );
extern void restore_break(void );
extern void n_gmode(int mode);
extern void save_cursor(void );
extern void restore_cursor(void );
extern void install_cursor(int );
extern void install_keyboard(void );
extern void fix_vid(void);

#define EXTERNS_H

#endif
