/*
            TCPIP.DLL  - TCP/IP stack for windows
            Written:        2-20-92     Joe Lepore
            Adapted from NCSA TELNET for DOS
*/

#include "windows.h"
int FAR PASCAL InitNetwork(void);
int FAR PASCAL DestroyDll(void);
void FAR PASCAL OutDebStr(LPSTR);

int bypass_passwd;          // kludge for ncsa
int iNbrHandles;            // # of Global handles allocated
HGLOBAL hHandles[400];      // Actual handles
char Signature[] = "Joe";   // debug signature


int FAR PASCAL LibMain(HANDLE hInstance,WORD wDataSeg,WORD wHeapSize,LPSTR lpszCmdLine)
{
//OutDebStr("TCPIP:LibMain:Init Start");
    iNbrHandles=-1;
    if(wHeapSize>0) UnlockData(0);
//OutDebStr("TCPIP:LibMain:Init Done");
    return(1);
}

void FAR PASCAL Wep(int ExitCode)
{
int x;
    switch(ExitCode){
        case WEP_SYSTEM_EXIT:
        case WEP_FREE_DLL:
//OutDebStr("TCPIP:WEP:bye bye");
            if(iNbrHandles>-1){
              for(x=0;x<iNbrHandles;x++){
                GlobalUnlock(hHandles[x]);
                GlobalFree(hHandles[x]);
              }
            }
            DestroyDll();
            break;
    }
}

LPSTR FAR _cdecl malloc(UINT bytes)
{
    if(iNbrHandles>399) return(NULL);
    hHandles[iNbrHandles]=GlobalAlloc(GHND,bytes);
    iNbrHandles++;
    if(hHandles[iNbrHandles-1]==NULL) OutDebStr("TCPIP:malloc:ALLOC FAILED!");
    return(GlobalLock(hHandles[iNbrHandles-1]));
}

void FAR PASCAL OutDebStr(LPSTR DebugString){
     OutputDebugString(DebugString);
     OutputDebugString("\r\n");
}



