

/* Stalk vertex positions */

static float xpos[8] = {1.0,0.7071,0.0,-0.7071,
   -1.0,-0.7071,0.0,0.7071};
static float ypos[8] = {0.0,0.7071,1.0,0.7071,
   0.0,-0.7071,-1.0,-0.7071};


/* Random setup makes drand return a double */

#ifdef __HIGHC__
#define RAND_MAX (sizeof(int) == 2 ? 32767 : 2147483647)
#endif
#define drand() ((double)rand()/RAND_MAX)


/* Some trig defines */

#define RD_22 0.3926990		/* Some angles in radians */
#define RD_45 0.7853981
#define RD_90 1.5707963
#define RD_180 3.1415927
#define RD_360 6.2831853


/* Structure for storing the cat tails */

typedef struct {
   unsigned short nvertex;
   VData *vt;              /* VData is defined in exprtn.h */
   unsigned short nface;
   FData *fc;              /* FData is defined in exprtn.h */
}MESHOBJ;

MESHOBJ obj;


/* Global variables */

int nweeds,nentf,nentv;
int overts,version3d;
float px,pz,position,weedwd,xoff,zoff;
float xfac,zfac,xdir,zdir,hper,curwd,endrg,segrg;
int first,ix;
int vertex,face;
float minx,miny,minz,maxx,maxy,maxz,dx,dy,dz;
unsigned char material;
long frame;


/* Function prototypes */

int studio_version();
int BuildCatTails(void);
