/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
#ifndef USERPROC_USER_H
 #define USERPROC_USER_H
 #define DRIVER_LABEL_SIZE          8
 #define NULL_PTR                   ((void far *) 0)
 #define USER_FAR                   far
 #define USERPROC_MAX_PARM          30

 typedef
    unsigned char  Uchar;
 typedef
    unsigned short Ushort;
typedef
   unsigned long Ulong;
#endif

#define MIN(a,b)                    (((a) < (b)) ? (a) : (b))

#define MODULE_LABEL_LEN            DRIVER_LABEL_SIZE
#define FUNC_NAME_LEN               20

#define USERPROC_ALPHA              'A'   /* parameter is string           */
#define USERPROC_LONG               'L'   /* --/--/--/-- pointer to long   */
#define USERPROC_DOUBLE             'D'   /* --/--/--/-- pointer to double */

#define USERPROC_DELIM              '.'   /* "module.func_name" delimiter */

#define TSR_SIGNATURE               0x38F6
#define TSR_INTERRUPT               0x7c
#define DRIVER_TYPE_USERPROC        'U'

/*------------------------------------------------------------------------*/
/* Tipes                                                                  */
/*------------------------------------------------------------------------*/
typedef     /* structure used internally for communication */
   struct
   {
      void USER_FAR *next_tsr_item;
      Ushort         sign;                     /* must be TSR_SIGNATURE */
      Ushort         psp_seg;
      Ushort         driver_type;               /* DRIVER_TYPE_USERPROC */
      Uchar          driver_label[DRIVER_LABEL_SIZE];
      void USER_FAR *driver_info;
      Ushort         use_cnt;
   } TSR_ITEM;

typedef     /* structure defining module function */
   struct
   {
       Uchar USER_FAR *func_name;  /* name (label) of a function */
       void  USER_FAR *func_addr;  /* pointer to function        */
       Ushort          arg_cnt;    /* number of arguments        */
       Uchar USER_FAR *arg_attrs;  /* string of attributes 'A','L','D' */
   }  FUNC_DSC;

typedef     /* structure defining module */
   struct
   {
      Ushort             use_cnt;         /* only for Magic use            */
      void     USER_FAR *ini_func_addr;   /* called upon initialization    */
      void     USER_FAR *trm_func_addr;   /* called upon termination       */
      Ushort             func_cnt;        /* number of functions in module */
      FUNC_DSC USER_FAR *func_dsc_tbl;    /* function table                */
      Uchar    USER_FAR *module_name;     /* name (label) of module        */
      Ushort             context_hdl;
   } TSR_MODULE;

/*-----------------------------------------------------------------------*/
/* Functions                                                             */
/*-----------------------------------------------------------------------*/
void cdecl userproc_tsr (TSR_MODULE *tsr_module, Ulong mem_required);

