/*-------------------------------------------------------------------------*/
/* This module includes a sample USERPROC routine.                         */
/*-------------------------------------------------------------------------*/
#include <windows.h>
#include "userdll.h"
#include <string.h>

/*-------------------------------------------------------------------------*/
/* Functions                                                               */
/*-------------------------------------------------------------------------*/
void far cdecl add_sub (char *op, long *num1, long *num2, long *num3);
void far mul_div (char *op, long *num1, long *num2, long *num3);

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
#define FUNC_CNT     2

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/

static FUNC_DSC fdsc_tbl[FUNC_CNT] =
   {
      {"add_sub", (void  far *) add_sub,  4, "ALLL"},
      {"mul_div", (void  far *) mul_div,  4, "ALLL"}
   };

static TSR_MODULE tsr_module =
   {0, NULL_PTR, NULL_PTR, FUNC_CNT, fdsc_tbl, (Uchar *) "myproc"} ;

/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
void *far pascal magic_bind (void)
{
   return (&tsr_module);
}

/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
int far pascal LibMain (HANDLE hInstance, WORD ds, WORD heap_size,
                        LPSTR lp_cmd_line)
{
   if (heap_size > 0)
      UnlockData (0);

   /*--------------------------------------------------------------*/
   /* if you plan to use floating point operation, you may need to */
   /* place a dummy floating operation here to help your compiler  */
   /* find its floating point libraries (i.e. Borland C)           */
   /*--------------------------------------------------------------*/

   return (1);
}
/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
void far cdecl add_sub (char *op, long *num1, long *num2, long *num3)
{
   switch (*op)
   {
      case 'A':
         *num3 = *num1 + *num2;
         break;
      case 'S':
         *num3 = *num1 - *num2;
         break;
      default:
         *num3 = 0;
         break;
   }
}

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
void far mul_div (char *op, long *num1, long *num2, long *num3)
{
   switch (*op)
   {
      case 'M':
         *num3 = *num1 * *num2;
         break;
      case 'D':
         if (*num2 == 0)
            *num3 = 0;
         else
            *num3 = *num1 / *num2;
         break;
      default:
         *num3 = 0;
         break;
   }
}
